/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.hypernet.old;

import crafttweaker.annotations.ZenRegister;
import github.kasuminova.mmce.common.event.recipe.RecipeCheckEvent;
import github.kasuminova.mmce.common.helper.IMachineController;
import github.kasuminova.novaeng.common.crafttweaker.hypernet.HyperNetHelper;
import github.kasuminova.novaeng.common.handler.HyperNetEventHandler;
import github.kasuminova.novaeng.common.hypernet.old.ComputationCenterType;
import github.kasuminova.novaeng.common.hypernet.old.NetNode;
import github.kasuminova.novaeng.common.hypernet.old.misc.ConnectResult;
import github.kasuminova.novaeng.common.registry.RegistryHyperNet;
import github.kasuminova.novaeng.common.util.RandomUtils;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.machine.factory.FactoryRecipeThread;
import hellfirepvp.modularmachinery.common.tiles.TileFactoryController;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenSetter;

@ZenRegister
@ZenClass(value="novaeng.hypernet.ComputationCenter")
public class ComputationCenter {
    private static final Map<TileMultiblockMachineController, ComputationCenter> CACHED_COMPUTATION_CENTER = new WeakHashMap<TileMultiblockMachineController, ComputationCenter>();
    private final TileMultiblockMachineController owner;
    private final Map<Class<?>, Map<BlockPos, NetNode>> nodes = new ConcurrentHashMap();
    private final ComputationCenterType type;
    private final AtomicReference<Double> computationPointCounter = new AtomicReference<Double>(0.0);
    private UUID networkOwner = null;
    private int circuitDurability = 0;

    public ComputationCenter(TileMultiblockMachineController owner, NBTTagCompound customData) {
        this.owner = owner;
        this.type = RegistryHyperNet.getComputationCenterType(Objects.requireNonNull(owner.getFoundMachine()).getRegistryName().func_110623_a());
        this.readNBT(customData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ZenMethod
    public static ComputationCenter from(IMachineController machine) {
        TileMultiblockMachineController ctrl = machine.getController();
        ComputationCenter computationCenter = CACHED_COMPUTATION_CENTER.get(ctrl);
        if (computationCenter == null) {
            Map<TileMultiblockMachineController, ComputationCenter> map = CACHED_COMPUTATION_CENTER;
            synchronized (map) {
                computationCenter = CACHED_COMPUTATION_CENTER.get(ctrl);
                if (computationCenter == null) {
                    computationCenter = new ComputationCenter(ctrl, ctrl.getCustomDataTag());
                    CACHED_COMPUTATION_CENTER.put(ctrl, computationCenter);
                }
            }
        }
        return computationCenter;
    }

    public static void clearCache() {
        CACHED_COMPUTATION_CENTER.clear();
    }

    @ZenMethod
    public void onRecipeCheck(RecipeCheckEvent event) {
        if ((float)this.circuitDurability < (float)this.type.getCircuitDurability() * 0.05f) {
            event.setFailed("\u7535\u8def\u677f\u8010\u4e45\u8fc7\u4f4e\uff0c\u65e0\u6cd5\u6b63\u5e38\u5de5\u4f5c\uff01");
        }
    }

    @ZenMethod
    public void onDurabilityFixRecipeCheck(RecipeCheckEvent event, int durability) {
        if (this.circuitDurability + durability > this.type.getCircuitDurability()) {
            event.setFailed("novaeng.hypernet.craftcheck.durability.failed");
        }
    }

    @ZenMethod
    public void onWorkingTick() {
        this.checkNodeConnection();
        this.consumeCircuitDurability();
        HyperNetEventHandler.addTickStartAction(this::resetComputationPointCounter);
    }

    @ZenMethod
    public void fixCircuit(int durability) {
        this.circuitDurability = Math.min(this.circuitDurability + durability, this.type.getCircuitDurability());
        this.writeNBT();
    }

    @ZenMethod
    public void onMachineTick() {
    }

    private void consumeCircuitDurability() {
        if (this.owner.getTicksExisted() % 20 != 0) {
            return;
        }
        float consumeChance = (float)((double)this.getConnectedMachineryCount() / (double)this.type.getMaxConnections() + this.getComputationPointGeneration() / this.type.getMaxComputationPointCarrying());
        if (!(RandomUtils.nextFloat() <= Math.max(this.type.getCircuitConsumeChance() * consumeChance, 0.01f))) {
            return;
        }
        int min = this.type.getMinCircuitConsumeAmount();
        int max = this.type.getMaxCircuitConsumeAmount();
        this.circuitDurability -= min + RandomUtils.nextInt(max - min);
        this.writeNBT();
    }

    private void checkNodeConnection() {
        if (this.owner.getTicksExisted() % 50 != 0) {
            return;
        }
        World world = this.owner.func_145831_w();
        this.nodes.forEach((clazz, nodes) -> {
            Iterator it = nodes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry next = it.next();
                BlockPos pos = (BlockPos)next.getKey();
                NetNode node = (NetNode)next.getValue();
                if (node.getOwner().func_145837_r()) {
                    it.remove();
                    continue;
                }
                if (world.func_175667_e(pos)) {
                    TileEntity te = world.func_175625_s(pos);
                    if (te instanceof TileMultiblockMachineController) continue;
                    it.remove();
                    continue;
                }
                ModularMachinery.EXECUTE_MANAGER.addSyncTask(() -> {
                    TileEntity te = world.func_175625_s(pos);
                    if (!(te instanceof TileMultiblockMachineController)) {
                        nodes.remove(pos);
                    }
                });
            }
        });
    }

    public ConnectResult onConnect(TileMultiblockMachineController machinery, NetNode node) {
        BlockPos pos;
        if (!this.isWorking()) {
            return ConnectResult.CENTER_NOT_WORKING;
        }
        Map connected = this.nodes.computeIfAbsent(node.getClass(), v -> new ConcurrentHashMap());
        if (connected.computeIfPresent(pos = machinery.func_174877_v(), (k, v) -> node) != null) {
            node.onConnected(this);
            return ConnectResult.SUCCESS;
        }
        if (this.getConnectedMachineryCount() >= this.type.getMaxConnections()) {
            return ConnectResult.CENTER_REACHED_CONNECTION_LIMIT;
        }
        if (!HyperNetHelper.supportsHyperNet(machinery)) {
            return ConnectResult.UNSUPPORTED_NODE;
        }
        if (connected.size() >= node.getNodeMaxPresences()) {
            return ConnectResult.NODE_TYPE_REACHED_MAX_PRESENCES;
        }
        connected.put(pos, node);
        node.onConnected(this);
        return ConnectResult.SUCCESS;
    }

    public void onDisconnect(TileMultiblockMachineController machinery, NetNode node) {
        this.nodes.computeIfAbsent(node.getClass(), v -> new ConcurrentHashMap()).remove(machinery.func_174877_v());
    }

    public <N extends NetNode> Collection<N> getNode(Class<N> type) {
        return this.nodes.computeIfAbsent(type, v -> new ConcurrentHashMap()).values();
    }

    public double consumeComputationPoint(double required) {
        if (!this.isWorking() || this.type.getMaxComputationPointCarrying() < required || this.computationPointCounter.get() < required) {
            return 0.0;
        }
        double[] polledCounter = new double[]{0.0};
        this.computationPointCounter.updateAndGet(counter -> {
            if (counter < required) {
                return counter;
            }
            polledCounter[0] = required;
            return counter - polledCounter[0];
        });
        if (polledCounter[0] < required) {
            this.computationPointCounter.updateAndGet(counter -> counter + polledCounter[0]);
            return 0.0;
        }
        double totalGenerated = 0.0;
        block0: for (Map<BlockPos, NetNode> nodes : this.nodes.values()) {
            for (NetNode node : nodes.values()) {
                double generated;
                if (!((totalGenerated += (generated = node.requireComputationPoint(required - totalGenerated, true))) >= required)) continue;
                break block0;
            }
        }
        double finalTotalGenerated = totalGenerated;
        this.computationPointCounter.updateAndGet(counter -> counter + (polledCounter[0] - finalTotalGenerated));
        if (required > totalGenerated && totalGenerated + 0.1 > required) {
            return required;
        }
        return totalGenerated;
    }

    public boolean isWorking() {
        TileMultiblockMachineController tileMultiblockMachineController = this.owner;
        if (!(tileMultiblockMachineController instanceof TileFactoryController)) {
            return false;
        }
        TileFactoryController factory = (TileFactoryController)tileMultiblockMachineController;
        FactoryRecipeThread thread = (FactoryRecipeThread)factory.getCoreRecipeThreads().get("novaeng.hypernet.data_forwarding_processor");
        return thread != null && thread.isWorking();
    }

    public void resetComputationPointCounter() {
        this.computationPointCounter.set(this.type.getMaxComputationPointCarrying());
    }

    @ZenMethod
    public void readNBT() {
        this.readNBT(this.owner.getCustomDataTag());
    }

    public void readNBT(NBTTagCompound customData) {
        this.circuitDurability = customData.func_74764_b("circuitDurability") ? customData.func_74762_e("circuitDurability") : this.type.getCircuitDurability();
        this.networkOwner = customData.func_74764_b("networkOwner") ? UUID.fromString(customData.func_74779_i("networkOwner")) : null;
    }

    @ZenMethod
    public void writeNBT() {
        NBTTagCompound tag = this.owner.getCustomDataTag();
        tag.func_74768_a("circuitDurability", this.circuitDurability);
        if (this.networkOwner != null) {
            tag.func_74778_a("networkOwner", this.networkOwner.toString());
        }
    }

    @ZenGetter(value="circuitDurability")
    public int getCircuitDurability() {
        return this.circuitDurability;
    }

    @ZenSetter(value="circuitDurability")
    public void setCircuitDurability(int circuitDurability) {
        this.circuitDurability = circuitDurability;
        this.writeNBT();
    }

    public UUID getNetworkOwner() {
        return this.networkOwner;
    }

    public void setNetworkOwner(UUID networkOwner) {
        this.networkOwner = networkOwner;
        this.writeNBT();
    }

    @ZenGetter(value="connectedMachineryCount")
    public int getConnectedMachineryCount() {
        return this.nodes.values().stream().mapToInt(Map::size).sum();
    }

    @ZenGetter(value="type")
    public ComputationCenterType getType() {
        return this.type;
    }

    @ZenGetter(value="computationPointGeneration")
    public double getComputationPointGeneration() {
        double maxCarry = this.type.getMaxComputationPointCarrying();
        double totalGeneration = 0.0;
        for (Map<BlockPos, NetNode> nodes : this.nodes.values()) {
            for (NetNode node : nodes.values()) {
                double generation = node.getComputationPointProvision(maxCarry);
                maxCarry -= generation;
                totalGeneration += generation;
            }
        }
        return totalGeneration;
    }

    @ZenGetter(value="computationPointConsumption")
    public double getComputationPointConsumption() {
        double sum = 0.0;
        for (Map<BlockPos, NetNode> map : this.nodes.values()) {
            for (NetNode node : map.values()) {
                sum += node.getComputationPointConsumption();
            }
        }
        return sum;
    }

    public TileMultiblockMachineController getOwner() {
        return this.owner;
    }
}

