/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.hypernet.computer.module.base;

import crafttweaker.annotations.ZenRegister;
import github.kasuminova.novaeng.common.crafttweaker.util.NovaEngUtils;
import github.kasuminova.novaeng.common.hypernet.calculation.Calculable;
import github.kasuminova.novaeng.common.hypernet.calculation.CalculateType;
import github.kasuminova.novaeng.common.hypernet.calculation.CalculateTypes;
import github.kasuminova.novaeng.common.hypernet.computer.module.ServerModule;
import github.kasuminova.novaeng.common.hypernet.computer.module.base.ServerModuleBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import net.minecraft.client.resources.I18n;
import stanhebben.zenscript.annotations.ZenClass;

@ZenRegister
@ZenClass(value="novaeng.hypernet.server.module.base.ModuleCalculableBase")
public abstract class ModuleCalculableBase<T extends ServerModule>
extends ServerModuleBase<T> {
    protected final double baseGeneration;
    protected final double energyConsumeRatio;
    protected final int hardwareBandwidth;

    public ModuleCalculableBase(String registryName, double baseGeneration, double energyConsumeRatio, int hardwareBandwidth) {
        super(registryName);
        this.baseGeneration = baseGeneration;
        this.energyConsumeRatio = energyConsumeRatio;
        this.hardwareBandwidth = hardwareBandwidth;
    }

    @Override
    public List<String> getTooltip(T moduleInstance) {
        ArrayList<String> tooltip = new ArrayList<String>(super.getTooltip(moduleInstance));
        tooltip.add(I18n.func_135052_a((String)"novaeng.hypernet.hardware_bandwidth.consume", (Object[])new Object[]{this.hardwareBandwidth}));
        tooltip.add(I18n.func_135052_a((String)"novaeng.hypernet.calculable.tip.base_ratio", (Object[])new Object[]{this.baseGeneration}));
        tooltip.add(I18n.func_135052_a((String)"novaeng.hypernet.calculable.tip.energy_consume_ratio", (Object[])new Object[]{NovaEngUtils.formatNumber(Math.round(this.energyConsumeRatio))}));
        tooltip.add(I18n.func_135052_a((String)"novaeng.hypernet.calculable.supported", (Object[])new Object[0]));
        PriorityQueue<EfficiencyTip> efficiencyTips = new PriorityQueue<EfficiencyTip>();
        for (CalculateType type : CalculateTypes.getAvailableTypes().values()) {
            double typeEfficiency = ((Calculable)moduleInstance).getCalculateTypeEfficiency(type);
            efficiencyTips.add(new EfficiencyTip(typeEfficiency, I18n.func_135052_a((String)"novaeng.hypernet.calculate.tip.efficiency", (Object[])new Object[]{type.getFormattedTypeName(), type.format(this.baseGeneration * typeEfficiency), Calculable.formatEfficiency(typeEfficiency)})));
        }
        for (EfficiencyTip efficiencyTip : efficiencyTips) {
            tooltip.add("  " + efficiencyTip.tip());
        }
        return tooltip;
    }

    static final class EfficiencyTip
    implements Comparable<EfficiencyTip> {
        private final double efficiency;
        private final String tip;

        EfficiencyTip(double efficiency, String tip) {
            this.efficiency = efficiency;
            this.tip = tip;
        }

        @Override
        public int compareTo(EfficiencyTip efficiencyTip) {
            return Double.compare(efficiencyTip.efficiency, this.efficiency);
        }

        public String toString() {
            return "EfficiencyTip[" + "efficiency=" + this.efficiency + "," + "tip=" + this.tip + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (int)(Double.doubleToLongBits(this.efficiency) ^ Double.doubleToLongBits(this.efficiency) >>> 32);
            result = 31 * result + (this.tip != null ? this.tip.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (((EfficiencyTip)arg0).efficiency != this.efficiency) {
                return false;
            }
            return Objects.equals(((EfficiencyTip)arg0).tip, this.tip);
            {
            }
        }

        public double efficiency() {
            return this.efficiency;
        }

        public String tip() {
            return this.tip;
        }
    }
}

