/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.hypernet.computer.module;

import crafttweaker.annotations.ZenRegister;
import github.kasuminova.novaeng.common.hypernet.calculation.Calculable;
import github.kasuminova.novaeng.common.hypernet.calculation.CalculateRequest;
import github.kasuminova.novaeng.common.hypernet.calculation.modifier.ModifierManager;
import github.kasuminova.novaeng.common.hypernet.computer.HardwareBandwidthConsumer;
import github.kasuminova.novaeng.common.hypernet.computer.ModularServer;
import github.kasuminova.novaeng.common.hypernet.computer.exception.ModularServerException;
import github.kasuminova.novaeng.common.hypernet.computer.module.ServerModule;
import github.kasuminova.novaeng.common.hypernet.computer.module.base.ServerModuleBase;
import stanhebben.zenscript.annotations.ZenClass;

@ZenRegister
@ZenClass(value="novaeng.hypernet.server.module.ModuleCalculable")
public abstract class ModuleCalculable
extends ServerModule
implements Calculable,
HardwareBandwidthConsumer {
    protected double baseGeneration;
    protected double energyConsumeRatio;
    protected int hardwareBandwidth;

    public ModuleCalculable(ModularServer server, ServerModuleBase<?> moduleBase, double baseGeneration, double energyConsumeRatio, int hardwareBandwidth) {
        super(server, moduleBase);
        this.baseGeneration = baseGeneration;
        this.energyConsumeRatio = energyConsumeRatio;
        this.hardwareBandwidth = hardwareBandwidth;
    }

    @Override
    public double calculate(CalculateRequest request) throws ModularServerException {
        double efficiency = this.getCalculateTypeEfficiency(request.type());
        ModifierManager modifier = request.modifier();
        double maxCanGenerated = modifier.apply("global_calculate_efficiency", modifier.apply(request.type().getModifierKey(), this.baseGeneration * efficiency));
        double generated = Math.min(maxCanGenerated, request.maxRequired());
        if (!request.simulate()) {
            this.getServer().consumeEnergy(Math.round(generated / efficiency * this.energyConsumeRatio));
        }
        return generated;
    }

    @Override
    public int getHardwareBandwidth() {
        return this.hardwareBandwidth;
    }

    public void setHardwareBandwidth(int hardwareBandwidth) {
        this.hardwareBandwidth = hardwareBandwidth;
    }

    public double getBaseGeneration() {
        return this.baseGeneration;
    }

    public void setBaseGeneration(double baseGeneration) {
        this.baseGeneration = baseGeneration;
    }

    public double getEnergyConsumeRatio() {
        return this.energyConsumeRatio;
    }

    public void setEnergyConsumeRatio(double energyConsumeRatio) {
        this.energyConsumeRatio = energyConsumeRatio;
    }
}

