/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.hypernet.computer;

import github.kasuminova.novaeng.common.container.slot.AssemblySlotManager;
import github.kasuminova.novaeng.common.hypernet.calculation.Calculable;
import github.kasuminova.novaeng.common.hypernet.calculation.CalculateReply;
import github.kasuminova.novaeng.common.hypernet.calculation.CalculateRequest;
import github.kasuminova.novaeng.common.hypernet.calculation.CalculateType;
import github.kasuminova.novaeng.common.hypernet.calculation.CalculateTypes;
import github.kasuminova.novaeng.common.hypernet.computer.CalculateServer;
import github.kasuminova.novaeng.common.hypernet.computer.Extension;
import github.kasuminova.novaeng.common.hypernet.computer.HardwareBandwidthConsumer;
import github.kasuminova.novaeng.common.hypernet.computer.HardwareBandwidthProvider;
import github.kasuminova.novaeng.common.hypernet.computer.ServerInvProvider;
import github.kasuminova.novaeng.common.hypernet.computer.exception.EnergyDeficitException;
import github.kasuminova.novaeng.common.hypernet.computer.exception.EnergyOverloadException;
import github.kasuminova.novaeng.common.hypernet.computer.exception.ModularServerException;
import github.kasuminova.novaeng.common.hypernet.computer.module.ModuleCapacitor;
import github.kasuminova.novaeng.common.hypernet.computer.module.ModulePSU;
import github.kasuminova.novaeng.common.hypernet.computer.module.ServerModule;
import github.kasuminova.novaeng.common.hypernet.computer.module.base.ServerModuleBase;
import github.kasuminova.novaeng.common.registry.ServerModuleRegistry;
import github.kasuminova.novaeng.common.util.TileItemHandler;
import hellfirepvp.modularmachinery.common.tiles.base.TileEntitySynchronized;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ModularServer
extends CalculateServer
implements ServerInvProvider {
    protected final AssemblySlotManager slotManager = new AssemblySlotManager(this);
    protected final TileEntitySynchronized owner;
    protected final Properties prop = new Properties();
    protected final List<ServerModule> modules = new ArrayList<ServerModule>();
    protected final List<Extension> extensions = new LinkedList<Extension>();
    protected final List<Calculable> calculables = new ArrayList<Calculable>();
    protected final Map<CalculateType, PriorityQueue<Calculable>> calculableTypeSet = new HashMap<CalculateType, PriorityQueue<Calculable>>();
    protected final Map<Class<?>, List<Object>> typeModulesCache = new HashMap();
    protected final Map<ServerModuleBase<?>, List<ServerModule>> baseModulesCache = new HashMap();
    protected Consumer<ModularServer> onServerInvChangedListener = null;
    protected boolean started = false;
    protected long energyCap = 0L;
    protected long maxEnergyCap = 0L;
    protected long energyConsumed = 0L;
    protected long maxEnergyConsumption = 0L;
    protected long maxEnergyProvision = 0L;
    protected int heatGenerated = 0;
    protected int totalHardwareBandwidth = 0;
    protected int usedHardwareBandwidth = 0;
    protected ItemStack cachedStack;
    protected TileItemHandler assemblyCPUInv = null;
    protected TileItemHandler assemblyCalculateCardInv = null;
    protected TileItemHandler assemblyExtensionInv = null;
    protected TileItemHandler assemblyPowerInv = null;

    public ModularServer(TileEntitySynchronized owner, ItemStack stack) {
        this.owner = owner;
        this.cachedStack = stack;
    }

    public boolean requiresUpdate(ItemStack newStack) {
        return newStack != this.cachedStack && !ItemUtils.matchStacks((ItemStack)this.cachedStack, (ItemStack)newStack);
    }

    public ItemStack getCachedStack() {
        return this.cachedStack;
    }

    public void setCachedStack(ItemStack cachedStack) {
        this.cachedStack = cachedStack;
    }

    @Override
    public CalculateReply calculate(CalculateRequest request) {
        if (!this.started && !request.simulate()) {
            return new CalculateReply(0.0);
        }
        PriorityQueue<Calculable> calculableSet = this.calculableTypeSet.get(request.type());
        if (calculableSet == null) {
            return new CalculateReply(0.0);
        }
        this.calculateHardwareBandwidthEfficiency(request);
        double totalGenerated = 0.0;
        double maxRequired = request.maxRequired();
        for (Extension extension : this.extensions) {
            extension.onCalculate(request);
        }
        for (Calculable calculable : calculableSet) {
            try {
                totalGenerated += calculable.calculate(request.subtractMaxRequired(totalGenerated));
            }
            catch (ModularServerException e) {
                this.started = false;
                return new CalculateReply(0.0);
            }
            if (!(totalGenerated >= maxRequired)) continue;
            break;
        }
        return new CalculateReply(totalGenerated);
    }

    public void initModules() {
        this.resetState();
        this.scanInvModules(this.assemblyCPUInv);
        this.scanInvModules(this.assemblyCalculateCardInv);
        this.scanInvModules(this.assemblyExtensionInv);
        this.scanInvModules(this.assemblyPowerInv);
        this.recalculateHardwareBandwidth();
        this.recalculateEnergySystem();
    }

    protected void scanInvModules(TileItemHandler moduleInv) {
        moduleInv.getAvailableSlotsStream().forEach(slot -> {
            if (!this.slotManager.getSlot(moduleInv.getInvName(), slot).isAvailable()) {
                return;
            }
            ItemStack stackInSlot = moduleInv.getStackInSlot(slot);
            if (stackInSlot.func_190926_b()) {
                return;
            }
            ServerModuleBase<?> module = ServerModuleRegistry.getModule(stackInSlot);
            if (module == null) {
                return;
            }
            Object moduleInstance = module.createInstance(this, stackInSlot);
            this.modules.add((ServerModule)moduleInstance);
            this.baseModulesCache.computeIfAbsent(module, v -> new ArrayList()).add(moduleInstance);
            if (moduleInstance instanceof Extension) {
                this.addExtension((Extension)moduleInstance);
            }
            if (moduleInstance instanceof Calculable) {
                this.addCalculable((Calculable)moduleInstance);
            }
        });
    }

    public void addExtension(@Nonnull Extension extension) {
        this.extensions.add(extension);
    }

    public void addCalculable(@Nonnull Calculable calculable) {
        this.calculables.add(calculable);
        for (CalculateType calculateType : CalculateTypes.getAvailableTypes().values()) {
            if (calculable.getCalculateTypeEfficiency(calculateType) <= 0.0) continue;
            this.calculableTypeSet.computeIfAbsent(calculateType, v -> new PriorityQueue((o1, o2) -> {
                double efficiencyRight;
                double efficiencyLeft = o1.getCalculateTypeEfficiency(calculateType);
                if (efficiencyLeft == (efficiencyRight = o2.getCalculateTypeEfficiency(calculateType))) {
                    return 0;
                }
                return efficiencyLeft < efficiencyRight ? 1 : -1;
            })).add(calculable);
        }
    }

    public void recalculateHardwareBandwidth() {
        int totalProvided = 0;
        int totalConsumed = 0;
        for (HardwareBandwidthProvider provider : this.getModulesByType(HardwareBandwidthProvider.class)) {
            totalProvided += provider.getHardwareBandwidthProvision();
        }
        this.totalHardwareBandwidth = totalProvided;
        for (HardwareBandwidthConsumer consumer : this.getModulesByType(HardwareBandwidthConsumer.class)) {
            totalConsumed += consumer.getHardwareBandwidth();
        }
        this.usedHardwareBandwidth = totalConsumed;
    }

    public int getTotalHardwareBandwidth() {
        return this.totalHardwareBandwidth;
    }

    public int getUsedHardwareBandwidth() {
        return this.usedHardwareBandwidth;
    }

    protected void calculateHardwareBandwidthEfficiency(CalculateRequest request) {
        if (this.totalHardwareBandwidth <= 0) {
            request.modifier().multiply("global_calculate_efficiency", 0.0);
            return;
        }
        float efficiency = Math.max(Math.min((float)this.totalHardwareBandwidth / (float)this.usedHardwareBandwidth, 1.0f), 0.5f);
        if (efficiency < 1.0f) {
            request.modifier().multiply("global_calculate_efficiency", efficiency);
        }
    }

    public void recalculateEnergySystem() {
        long maxEnergyProvision = 0L;
        for (ModulePSU modulePSU : this.getModulesByType(ModulePSU.class)) {
            maxEnergyProvision += modulePSU.getMaxEnergyProvision();
        }
        this.maxEnergyProvision = maxEnergyProvision;
        long maxEnergyCap = 0L;
        long maxEnergyConsumption = 0L;
        for (ModuleCapacitor capacitor : this.getModulesByType(ModuleCapacitor.class)) {
            maxEnergyCap += capacitor.getMaxEnergyCapProvision();
            maxEnergyConsumption += capacitor.getMaxEnergyConsumptionProvision();
        }
        this.maxEnergyCap = maxEnergyCap;
        this.maxEnergyConsumption = maxEnergyConsumption;
    }

    public long provideEnergy(long amount) {
        long maxCanProvide = Math.min(Math.min(this.maxEnergyCap - this.energyCap, this.maxEnergyProvision), amount);
        this.energyCap += maxCanProvide;
        return maxCanProvide;
    }

    public long consumeEnergy(long amount) throws ModularServerException {
        if (amount > this.energyCap) {
            this.energyConsumed += this.energyCap;
            this.energyCap = 0L;
            throw new EnergyDeficitException();
        }
        long maxCanConsume = Math.min(this.maxEnergyConsumption - this.energyConsumed, amount);
        this.energyConsumed += maxCanConsume;
        this.energyCap -= maxCanConsume;
        if (amount > maxCanConsume) {
            throw new EnergyOverloadException();
        }
        return maxCanConsume;
    }

    public long getEnergyCap() {
        return this.energyCap;
    }

    public void generateHeat(int amount) {
        this.heatGenerated += amount;
    }

    public int removeHeat() {
        int prev = this.heatGenerated;
        this.heatGenerated = 0;
        return prev;
    }

    public <T> List<T> getModulesByType(Class<T> type) {
        List<Object> cache = this.typeModulesCache.get(type);
        if (cache != null) {
            return cache;
        }
        ArrayList<ServerModule> matched = new ArrayList<ServerModule>();
        for (ServerModule module : this.modules) {
            if (!type.isAssignableFrom(module.getClass())) continue;
            matched.add(module);
        }
        this.typeModulesCache.put(type, matched);
        return matched;
    }

    public List<ServerModule> getModulesByBase(ServerModuleBase<?> base) {
        return this.baseModulesCache.getOrDefault(base, Collections.emptyList());
    }

    public void readFullInvNBT(NBTTagCompound stackTag) {
        this.readAssemblyCPUInv(stackTag.func_74775_l("cpuInv"));
        this.readAssemblyCalculateCardInv(stackTag.func_74775_l("calInv"));
        this.readAssemblyExtensionInv(stackTag.func_74775_l("extInv"));
        this.readAssemblyPowerInv(stackTag.func_74775_l("powerInv"));
        this.prop.readNBT(stackTag.func_74775_l("prop"));
        this.slotManager.initSlots();
    }

    public NBTTagCompound writeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("cpuInv", (NBTBase)this.assemblyCPUInv.writeNBT());
        tag.func_74782_a("calInv", (NBTBase)this.assemblyCalculateCardInv.writeNBT());
        tag.func_74782_a("extInv", (NBTBase)this.assemblyExtensionInv.writeNBT());
        tag.func_74782_a("powerInv", (NBTBase)this.assemblyPowerInv.writeNBT());
        tag.func_74782_a("prop", (NBTBase)this.prop.writeNBT());
        return tag;
    }

    public void initInv() {
        this.createDefaultAssemblyCPUInv();
        this.createDefaultAssemblyCalculateCardInv();
        this.createDefaultAssemblyExtensionInv();
        this.createDefaultAssemblyPowerInv();
        this.slotManager.initSlots();
    }

    public void onAssemblyInvUpdate(int changedSlot) {
        if (this.onServerInvChangedListener != null) {
            this.onServerInvChangedListener.accept(this);
        }
    }

    public void readAssemblyCPUInv(NBTTagCompound stackTag) {
        this.createDefaultAssemblyCPUInv();
        if (stackTag.func_82582_d()) {
            return;
        }
        this.assemblyCPUInv.readNBT(stackTag);
    }

    public void createDefaultAssemblyCPUInv() {
        this.assemblyCPUInv = TileItemHandler.create(this.owner, 41, "cpu").setOnChangedListener(this::onAssemblyInvUpdate);
    }

    public void readAssemblyCalculateCardInv(NBTTagCompound stackTag) {
        this.createDefaultAssemblyCalculateCardInv();
        if (stackTag.func_82582_d()) {
            return;
        }
        this.assemblyCalculateCardInv.readNBT(stackTag);
    }

    public void createDefaultAssemblyCalculateCardInv() {
        this.assemblyCalculateCardInv = TileItemHandler.create(this.owner, 20, "calculate_card").setOnChangedListener(this::onAssemblyInvUpdate);
    }

    public void readAssemblyExtensionInv(NBTTagCompound stackTag) {
        this.createDefaultAssemblyExtensionInv();
        if (stackTag.func_82582_d()) {
            return;
        }
        this.assemblyExtensionInv.readNBT(stackTag);
    }

    public void createDefaultAssemblyExtensionInv() {
        this.assemblyExtensionInv = TileItemHandler.create(this.owner, 36, "extension").setOnChangedListener(this::onAssemblyInvUpdate);
    }

    public void readAssemblyPowerInv(NBTTagCompound stackTag) {
        this.createDefaultAssemblyPowerInv();
        if (stackTag.func_82582_d()) {
            return;
        }
        this.assemblyPowerInv.readNBT(stackTag);
    }

    public void createDefaultAssemblyPowerInv() {
        this.assemblyPowerInv = TileItemHandler.create(this.owner, 8, "power").setOnChangedListener(this::onAssemblyInvUpdate);
    }

    @Override
    public TileItemHandler getInvByName(String name) {
        TileItemHandler tileItemHandler;
        switch (name) {
            case "cpu": {
                tileItemHandler = this.assemblyCPUInv;
                break;
            }
            case "calculate_card": {
                tileItemHandler = this.assemblyCalculateCardInv;
                break;
            }
            case "extension": {
                tileItemHandler = this.assemblyExtensionInv;
                break;
            }
            case "power": {
                tileItemHandler = this.assemblyPowerInv;
                break;
            }
            default: {
                tileItemHandler = null;
            }
        }
        return tileItemHandler;
    }

    protected void resetState() {
        this.modules.clear();
        this.extensions.clear();
        this.calculables.clear();
        this.calculableTypeSet.clear();
        this.typeModulesCache.clear();
        this.baseModulesCache.clear();
        this.energyCap = 0L;
        this.maxEnergyCap = 0L;
        this.energyConsumed = 0L;
        this.maxEnergyConsumption = 0L;
        this.maxEnergyProvision = 0L;
    }

    public void invalidate() {
        this.resetState();
        this.assemblyCPUInv.clear();
        this.assemblyCalculateCardInv.clear();
        this.assemblyExtensionInv.clear();
        this.assemblyPowerInv.clear();
    }

    public void setOnServerInvChangedListener(Consumer<ModularServer> onServerInvChangedListener) {
        this.onServerInvChangedListener = onServerInvChangedListener;
    }

    public double getCalculateAvgEfficiency(CalculateType type) {
        PriorityQueue<Calculable> calculables = this.calculableTypeSet.get(type);
        if (calculables == null || calculables.isEmpty()) {
            return 0.0;
        }
        double efficiency = 0.0;
        for (Calculable calculable : calculables) {
            efficiency += calculable.getCalculateTypeEfficiency(type);
        }
        return efficiency / (double)this.calculables.size();
    }

    public TileEntitySynchronized getOwner() {
        return this.owner;
    }

    public AssemblySlotManager getSlotManager() {
        return this.slotManager;
    }

    public List<ServerModule> getModules() {
        return this.modules;
    }

    public Map<CalculateType, PriorityQueue<Calculable>> getCalculableTypeSet() {
        return Collections.unmodifiableMap(this.calculableTypeSet);
    }

    public boolean isStarted() {
        return this.started;
    }

    public long getMaxEnergyCap() {
        return this.maxEnergyCap;
    }

    public long getMaxEnergyConsumption() {
        return this.maxEnergyConsumption;
    }

    public long getMaxEnergyProvision() {
        return this.maxEnergyProvision;
    }

    public static class Properties {
        private float unlockLimit = 2.0f;

        public NBTTagCompound writeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74776_a("unlockLimit", this.unlockLimit);
            return tag;
        }

        public void readNBT(NBTTagCompound tag) {
            this.unlockLimit = tag.func_74760_g("unlockLimit");
        }
    }
}

