/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.hypernet.calculation;

import github.kasuminova.novaeng.common.crafttweaker.util.NovaEngUtils;
import github.kasuminova.novaeng.common.hypernet.calculation.CalculateType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class CalculateTypes {
    public static final CalculateTypeIntricate INTRICATE = new CalculateTypeIntricate();
    public static final CalculateTypeLogic LOGIC = new CalculateTypeLogic();
    public static final CalculateTypeNeuron NEURON = new CalculateTypeNeuron();
    public static final CalculateTypeQbit QBIT = new CalculateTypeQbit();
    private static final Map<String, CalculateType> AVAILABLE_TYPES = new LinkedHashMap<String, CalculateType>();

    public static void registerType(CalculateType type) {
        AVAILABLE_TYPES.put(type.typeName, type);
    }

    public static CalculateType getTypeByName(String typeName) {
        return AVAILABLE_TYPES.get(typeName);
    }

    public static Map<String, CalculateType> getAvailableTypes() {
        return Collections.unmodifiableMap(AVAILABLE_TYPES);
    }

    static {
        CalculateTypes.registerType(INTRICATE);
        CalculateTypes.registerType(LOGIC);
        CalculateTypes.registerType(NEURON);
        CalculateTypes.registerType(QBIT);
    }

    public static class CalculateTypeIntricate
    extends CalculateType {
        CalculateTypeIntricate() {
            super("intricate");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public String format(double value) {
            return I18n.func_135052_a((String)("novaeng.hypernet.calculate.type." + this.typeName), (Object[])new Object[]{CalculateTypeIntricate.formatLogic(value)});
        }

        static String formatLogic(double value) {
            if (value < 1.0) {
                return NovaEngUtils.formatDouble(value * 1000.0, 1) + "G";
            }
            if (value < 1000.0) {
                return NovaEngUtils.formatDouble(value, 2) + "T";
            }
            if (value < 1000000.0) {
                return NovaEngUtils.formatDouble(value / 1000.0, 3) + "P";
            }
            return NovaEngUtils.formatDouble(value / 1000000.0, 3) + "E";
        }
    }

    public static class CalculateTypeLogic
    extends CalculateType {
        CalculateTypeLogic() {
            super("logic");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public String format(double value) {
            return I18n.func_135052_a((String)("novaeng.hypernet.calculate.type." + this.typeName), (Object[])new Object[]{CalculateTypeIntricate.formatLogic(value)});
        }
    }

    public static class CalculateTypeNeuron
    extends CalculateType {
        CalculateTypeNeuron() {
            super("neuron");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public String format(double value) {
            return I18n.func_135052_a((String)("novaeng.hypernet.calculate.type." + this.typeName), (Object[])new Object[]{NovaEngUtils.formatDouble(value, 3)});
        }
    }

    public static class CalculateTypeQbit
    extends CalculateType {
        CalculateTypeQbit() {
            super("qbit");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public String format(double value) {
            return I18n.func_135052_a((String)("novaeng.hypernet.calculate.type." + this.typeName), (Object[])new Object[]{NovaEngUtils.formatDouble(value, 3)});
        }
    }
}

