/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.hypernet.calculation;

import github.kasuminova.novaeng.common.crafttweaker.util.NovaEngUtils;
import github.kasuminova.novaeng.common.hypernet.calculation.CalculateRequest;
import github.kasuminova.novaeng.common.hypernet.calculation.CalculateType;
import github.kasuminova.novaeng.common.hypernet.computer.exception.ModularServerException;
import net.minecraft.util.text.TextFormatting;

public interface Calculable {
    public double calculate(CalculateRequest var1) throws ModularServerException;

    public double getCalculateTypeEfficiency(CalculateType var1);

    default public double applyEfficiency(double value, CalculateType type) {
        return value * this.getCalculateTypeEfficiency(type);
    }

    public static String formatEfficiency(double value) {
        String formattedValue = NovaEngUtils.formatDouble(value * 100.0, 3);
        if (value >= 5.0) {
            return TextFormatting.DARK_PURPLE + formattedValue + TextFormatting.WHITE;
        }
        if (value > 1.0) {
            return TextFormatting.BLUE + formattedValue + TextFormatting.WHITE;
        }
        if (value == 1.0) {
            return TextFormatting.GREEN + formattedValue + TextFormatting.WHITE;
        }
        if (value >= 0.5) {
            return TextFormatting.YELLOW + formattedValue + TextFormatting.WHITE;
        }
        return TextFormatting.RED + formattedValue + TextFormatting.WHITE;
    }
}

