/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.hypernet;

import com.mojang.authlib.GameProfile;
import github.kasuminova.novaeng.common.hypernet.NetNode;
import github.kasuminova.novaeng.common.hypernet.perm.UserPerm;
import github.kasuminova.novaeng.common.util.WorldPos;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class HyperNet {
    private final UUID owner;
    private final Map<UUID, UserPerm> userPerms = new Object2ObjectLinkedOpenHashMap();
    private final Map<Class<? extends NetNode>, Map<WorldPos, NetNode>> onlineNodes = new ConcurrentHashMap<Class<? extends NetNode>, Map<WorldPos, NetNode>>();
    private String ownerName;
    private String name;

    public HyperNet(EntityPlayer owner) {
        GameProfile profile = owner.func_146103_bH();
        this.owner = profile.getId();
        this.ownerName = profile.getName();
        this.name = profile.getName() + "'s HyperNet";
    }

    public HyperNet(NBTTagCompound tag, UUID owner) {
        this.owner = owner;
        this.ownerName = tag.func_74779_i("ownerName");
        this.name = tag.func_74779_i("name");
    }

    private void addNode(NetNode node) {
        Map nodes = this.onlineNodes.computeIfAbsent(node.getClass(), k -> new ConcurrentHashMap());
        nodes.put(node.getPos(), node);
    }

    private void removeNode(NetNode node) {
        Map<WorldPos, NetNode> nodes = this.onlineNodes.get(node.getClass());
        if (nodes != null) {
            nodes.remove(node.getPos());
        }
    }

    public Map<WorldPos, NetNode> getNodes(Class<? extends NetNode> nodeClass) {
        return this.onlineNodes.computeIfAbsent(nodeClass, k -> new ConcurrentHashMap());
    }

    public boolean hasPerm(EntityPlayer player, UserPerm permission) {
        return this.userPerms.getOrDefault(player.func_146103_bH().getId(), UserPerm.NONE).getLevel() >= permission.getLevel();
    }

    public void addUser(EntityPlayer player, UserPerm permission) {
        this.userPerms.put(player.func_146103_bH().getId(), permission);
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("name", this.name);
        tag.func_74778_a("ownerName", this.ownerName);
        return tag;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

