/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.handler;

import github.kasuminova.mmce.common.event.Phase;
import github.kasuminova.mmce.common.event.machine.MachineTickEvent;
import github.kasuminova.novaeng.NovaEngineeringCore;
import github.kasuminova.novaeng.common.hypernet.old.NetNode;
import github.kasuminova.novaeng.common.hypernet.old.NetNodeCache;
import github.kasuminova.novaeng.common.registry.RegistryHyperNet;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import net.minecraft.util.ResourceLocation;

public class HyperNetMachineEventHandler {
    public static void onMachineTick(MachineTickEvent event) {
        DynamicMachine foundMachine;
        if (event.phase != Phase.START) {
            return;
        }
        TileMultiblockMachineController ctrl = event.getController();
        NetNode cached = NetNodeCache.getCache(ctrl, RegistryHyperNet.getNodeType(foundMachine = ctrl.getFoundMachine()));
        if (cached != null) {
            cached.onMachineTick();
        }
    }

    public static void registerHandler() {
        for (ResourceLocation machineName : RegistryHyperNet.getAllHyperNetSupportedMachinery()) {
            DynamicMachine machine = MachineRegistry.getRegistry().getMachine(machineName);
            if (machine == null) {
                NovaEngineeringCore.log.warn("Cloud not find hypernet machine " + machineName + "!");
                continue;
            }
            machine.addMachineEventHandler(MachineTickEvent.class, HyperNetMachineEventHandler::onMachineTick);
        }
    }
}

