/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.handler;

import github.kasuminova.mmce.common.helper.IMachineController;
import github.kasuminova.mmce.common.util.concurrent.Action;
import github.kasuminova.mmce.common.util.concurrent.Queues;
import github.kasuminova.novaeng.NovaEngineeringCore;
import github.kasuminova.novaeng.common.crafttweaker.hypernet.HyperNetHelper;
import github.kasuminova.novaeng.common.hypernet.old.ComputationCenter;
import github.kasuminova.novaeng.common.hypernet.old.NetNode;
import github.kasuminova.novaeng.common.hypernet.old.NetNodeCache;
import github.kasuminova.novaeng.common.hypernet.old.misc.ConnectResult;
import github.kasuminova.novaeng.common.hypernet.old.misc.HyperNetConnectCardInfo;
import github.kasuminova.novaeng.common.network.PktHyperNetStatus;
import github.kasuminova.novaeng.common.network.PktTerminalGuiData;
import github.kasuminova.novaeng.common.registry.RegistryHyperNet;
import github.kasuminova.novaeng.common.tile.TileHyperNetTerminal;
import hellfirepvp.modularmachinery.common.container.ContainerBase;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.tiles.TileFactoryController;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import io.netty.util.internal.ThrowableUtil;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class HyperNetEventHandler {
    public static final HyperNetEventHandler INSTANCE = new HyperNetEventHandler();
    private static final Queue<Action> TICK_START_ACTIONS = Queues.createConcurrentQueue();
    private static final Queue<Action> TICK_END_ACTIONS = Queues.createConcurrentQueue();

    public static void addTickStartAction(Action action) {
        TICK_START_ACTIONS.offer(action);
    }

    public static void addTickEndAction(Action action) {
        TICK_END_ACTIONS.offer(action);
    }

    private HyperNetEventHandler() {
    }

    private static ComputationCenter getCenterFromNode(TileMultiblockMachineController ctrl) {
        NBTTagCompound customData = ctrl.getCustomDataTag();
        if (!customData.func_74764_b("centerPos")) {
            return null;
        }
        BlockPos centerPos = BlockPos.func_177969_a((long)customData.func_74763_f("centerPos"));
        if (!ctrl.func_145831_w().func_175667_e(centerPos)) {
            return null;
        }
        TileEntity te = ctrl.func_145831_w().func_175625_s(centerPos);
        if (!(te instanceof TileMultiblockMachineController)) {
            return null;
        }
        TileMultiblockMachineController center = (TileMultiblockMachineController)te;
        if (!HyperNetHelper.supportsHyperNet(center) || !HyperNetHelper.isComputationCenter(center)) {
            return null;
        }
        return ComputationCenter.from((IMachineController)center);
    }

    private static void sendResultMessage(ConnectResult result, EntityPlayer player, ComputationCenter center, NetNode cached) {
        switch (result) {
            case SUCCESS: {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("novaeng.hypernet.connect.result.success", new Object[]{center.getConnectedMachineryCount(), center.getType().getMaxConnections()}));
                break;
            }
            case UNKNOWN_CENTER: {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("novaeng.hypernet.connect.result.unknown_center", new Object[0]));
                break;
            }
            case CENTER_NOT_WORKING: {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("novaeng.hypernet.connect.result.center_not_working", new Object[0]));
                break;
            }
            case UNSUPPORTED_NODE: {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("novaeng.hypernet.connect.result.unsupported_node", new Object[0]));
                break;
            }
            case CENTER_REACHED_CONNECTION_LIMIT: {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("novaeng.hypernet.connect.result.center_reached_connection_limit", new Object[]{center.getType().getMaxConnections()}));
                break;
            }
            case NODE_TYPE_REACHED_MAX_PRESENCES: {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("novaeng.hypernet.connect.result.node_type_reached_max_presences", new Object[]{cached.getNodeMaxPresences()}));
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side.isClient()) {
            return;
        }
        switch (event.phase) {
            case START: {
                Action action;
                while ((action = TICK_START_ACTIONS.poll()) != null) {
                    try {
                        action.doAction();
                    }
                    catch (Exception e) {
                        NovaEngineeringCore.log.warn(ThrowableUtil.stackTraceToString((Throwable)e));
                    }
                }
                break;
            }
            case END: {
                Action action;
                while ((action = TICK_END_ACTIONS.poll()) != null) {
                    try {
                        action.doAction();
                    }
                    catch (Exception e) {
                        NovaEngineeringCore.log.warn(ThrowableUtil.stackTraceToString((Throwable)e));
                    }
                }
                break;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack;
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (player.func_70093_af()) {
            return;
        }
        TileEntity te = world.func_175625_s(event.getPos());
        if (!(te instanceof TileMultiblockMachineController)) {
            return;
        }
        TileMultiblockMachineController ctrl = (TileMultiblockMachineController)te;
        if (te instanceof TileHyperNetTerminal) {
            TileHyperNetTerminal terminal = (TileHyperNetTerminal)te;
            if (player instanceof EntityPlayerMP) {
                NovaEngineeringCore.NET_CHANNEL.sendTo((IMessage)new PktTerminalGuiData(terminal), (EntityPlayerMP)player);
                return;
            }
        }
        if ((stack = event.getItemStack()).func_77973_b() != RegistryHyperNet.getHyperNetConnectCard()) {
            return;
        }
        DynamicMachine foundMachine = ctrl.getFoundMachine();
        if (!RegistryHyperNet.isHyperNetSupported(foundMachine)) {
            return;
        }
        event.setCanceled(true);
        if (RegistryHyperNet.isComputationCenter(foundMachine.getRegistryName())) {
            ComputationCenter center = ComputationCenter.from((IMachineController)ctrl);
            if (center == null) {
                return;
            }
            UUID networkOwner = center.getNetworkOwner();
            UUID playerID = player.func_146103_bH().getId();
            if (networkOwner != null && !networkOwner.equals(playerID)) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("novaeng.hypernet.connect_card.write_failed.no_permission", new Object[0]));
                return;
            }
            if (networkOwner == null) {
                center.setNetworkOwner(playerID);
                player.func_145747_a((ITextComponent)new TextComponentTranslation("novaeng.hypernet.connect_card.write_success.new_owner", new Object[0]));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("novaeng.hypernet.connect_card.write_success", new Object[0]));
            }
            HyperNetHelper.writeConnectCardInfo(center, playerID, stack);
            return;
        }
        HyperNetEventHandler.tryConnectToCenter(ctrl, stack, world, player, foundMachine);
    }

    private static void tryConnectToCenter(TileMultiblockMachineController ctrl, ItemStack stack, World world, EntityPlayer player, DynamicMachine foundMachine) {
        TileFactoryController centerCtrl;
        HyperNetConnectCardInfo info = HyperNetHelper.readConnectCardInfo((IMachineController)ctrl, stack);
        if (info == null || !world.func_175667_e(info.getPos())) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("novaeng.hypernet.connect.result.unknown_center", new Object[0]));
            return;
        }
        BlockPos centerPos = info.getPos();
        TileEntity centerTE = world.func_175625_s(centerPos);
        TileFactoryController tileFactoryController = centerCtrl = centerTE instanceof TileFactoryController ? (TileFactoryController)centerTE : null;
        if (centerCtrl == null || !HyperNetHelper.isComputationCenter((TileMultiblockMachineController)centerCtrl)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("novaeng.hypernet.connect.result.unknown_center", new Object[0]));
            return;
        }
        NetNode cached = NetNodeCache.getCache(ctrl, RegistryHyperNet.getNodeType(foundMachine));
        ComputationCenter center = ComputationCenter.from((IMachineController)centerCtrl);
        if (cached == null || center == null) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("novaeng.hypernet.connect.result.unknown_center", new Object[0]));
            return;
        }
        if (!info.getNetworkOwner().equals(center.getNetworkOwner())) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("novaeng.hypernet.connect.result.no_permission", new Object[0]));
            return;
        }
        ConnectResult result = cached.connectTo(centerPos);
        HyperNetEventHandler.sendResultMessage(result, player, center, cached);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ComputationCenter center;
        if (event.phase != TickEvent.Phase.START || event.side == Side.CLIENT) {
            return;
        }
        EntityPlayer entityPlayer = event.player;
        if (!(entityPlayer instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)entityPlayer;
        World world = player.func_130014_f_();
        if (world.func_82737_E() % 15L != 0L) {
            return;
        }
        if (!(player.field_71070_bA instanceof ContainerBase)) {
            return;
        }
        TileEntity te = ((ContainerBase)player.field_71070_bA).getOwner();
        if (!(te instanceof TileMultiblockMachineController)) {
            return;
        }
        TileMultiblockMachineController ctrl = (TileMultiblockMachineController)te;
        if (!HyperNetHelper.supportsHyperNet(ctrl)) {
            return;
        }
        if (ctrl instanceof TileHyperNetTerminal) {
            TileHyperNetTerminal terminal = (TileHyperNetTerminal)ctrl;
            NovaEngineeringCore.NET_CHANNEL.sendTo((IMessage)new PktTerminalGuiData(terminal), player);
        }
        ComputationCenter computationCenter = center = HyperNetHelper.isComputationCenter(ctrl) ? ComputationCenter.from((IMachineController)ctrl) : HyperNetEventHandler.getCenterFromNode(ctrl);
        if (center != null) {
            NovaEngineeringCore.NET_CHANNEL.sendTo((IMessage)new PktHyperNetStatus(center), player);
        }
    }
}

