/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.handler;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.ISecurityGrid;
import appeng.me.helpers.IGridProxyable;
import appeng.tile.inventory.AppEngCellInventory;
import github.kasuminova.novaeng.NovaEngineeringCore;
import github.kasuminova.novaeng.common.container.ContainerEStorageController;
import github.kasuminova.novaeng.common.estorage.EStorageCellHandler;
import github.kasuminova.novaeng.common.network.PktEStorageGUIData;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageCellDrive;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageController;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageMEChannel;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class EStorageEventHandler {
    public static final EStorageEventHandler INSTANCE = new EStorageEventHandler();

    private static boolean canInteract(EntityPlayer player, IGridProxyable proxyable) {
        IGridNode gn = proxyable.getProxy().getNode();
        if (gn != null) {
            IGrid g = gn.getGrid();
            IEnergyGrid eg = (IEnergyGrid)g.getCache(IEnergyGrid.class);
            if (!eg.isNetworkPowered()) {
                return true;
            }
            ISecurityGrid sg = (ISecurityGrid)g.getCache(ISecurityGrid.class);
            return sg.hasPermission(player, SecurityPermissions.BUILD);
        }
        return true;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        EStorageMEChannel channel;
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        EnumHand hand = event.getHand();
        if (hand != EnumHand.MAIN_HAND) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (!player.func_70093_af()) {
            return;
        }
        TileEntity te = world.func_175625_s(event.getPos());
        if (!(te instanceof EStorageCellDrive)) {
            return;
        }
        EStorageCellDrive drive = (EStorageCellDrive)te;
        EStorageController controller = (EStorageController)((Object)drive.getController());
        if (controller != null && (channel = controller.getChannel()) != null && !EStorageEventHandler.canInteract(player, channel)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("novaeng.estorage_cell_drive.player.no_permission", new Object[0]));
            event.setCanceled(true);
            return;
        }
        ItemStack stackInHand = player.func_184586_b(hand);
        AppEngCellInventory inv = drive.getDriveInv();
        ItemStack stackInSlot = inv.getStackInSlot(0);
        if (stackInSlot.func_190926_b()) {
            if (stackInHand.func_190926_b() || EStorageCellHandler.getHandler(stackInHand) == null) {
                return;
            }
            player.func_184201_a(EntityEquipmentSlot.MAINHAND, inv.insertItem(0, stackInHand.func_77946_l(), false));
            player.func_145747_a((ITextComponent)new TextComponentTranslation("novaeng.estorage_cell_drive.player.inserted", new Object[0]));
            event.setCanceled(true);
            return;
        }
        if (!stackInHand.func_190926_b()) {
            return;
        }
        player.func_184201_a(EntityEquipmentSlot.MAINHAND, inv.extractItem(0, stackInSlot.func_190916_E(), false));
        player.func_145747_a((ITextComponent)new TextComponentTranslation("novaeng.estorage_cell_drive.player.removed", new Object[0]));
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START || event.side == Side.CLIENT) {
            return;
        }
        EntityPlayer entityPlayer = event.player;
        if (!(entityPlayer instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)entityPlayer;
        Container container = player.field_71070_bA;
        if (!(container instanceof ContainerEStorageController)) {
            return;
        }
        ContainerEStorageController containerESController = (ContainerEStorageController)container;
        World world = player.func_130014_f_();
        int tickExisted = containerESController.getTickExisted();
        containerESController.setTickExisted(tickExisted + 1);
        if (world.func_82737_E() % 20L != 0L && tickExisted > 1) {
            return;
        }
        EStorageController controller = (EStorageController)containerESController.getOwner();
        NovaEngineeringCore.NET_CHANNEL.sendTo((IMessage)new PktEStorageGUIData(controller), player);
    }
}

