/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.estorage;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.exceptions.AppEngException;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.me.storage.AbstractCellInventory;
import github.kasuminova.novaeng.NovaEngineeringCore;
import github.kasuminova.novaeng.common.item.estorage.EStorageCell;
import github.kasuminova.novaeng.mixin.ae2.AccessorAbstractCellInventory;
import io.netty.util.internal.ThrowableUtil;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class EStorageCellInventory<T extends IAEStack<T>>
extends AbstractCellInventory<T> {
    public static final String ITEM_SLOT = "#";
    public static final String ITEM_SLOT_COUNT = "@";
    public static final String ITEM_TYPE_TAG = "it";
    public static final String ITEM_COUNT_TAG = "ic";
    private final EStorageCell<T> cellType;
    private final IStorageChannel<T> channel;

    protected EStorageCellInventory(EStorageCell<T> cellType, ItemStack o, ISaveProvider container) {
        super(cellType, o, container);
        ReflectionHelper.setPrivateValue(AbstractCellInventory.class, (Object)((Object)this), (Object)cellType.getTotalTypes(o), (String)"maxItemTypes", null);
        this.cellType = cellType;
        this.channel = cellType.getChannel();
    }

    public static <T extends IAEStack<T>> ICellInventory<T> createInventory(ItemStack o, ISaveProvider container) {
        try {
            if (o == null) {
                throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
            }
            Item type = o.func_77973_b();
            if (!(type instanceof EStorageCell)) {
                throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
            }
            EStorageCell cellType = (EStorageCell)type;
            if (!cellType.isStorageCell(o)) {
                throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
            }
            return new EStorageCellInventory<T>(cellType, o, container);
        }
        catch (AppEngException e) {
            NovaEngineeringCore.log.error(ThrowableUtil.stackTraceToString((Throwable)e));
            return null;
        }
    }

    private boolean isStorageCell(T input) {
        if (input instanceof IAEItemStack) {
            IAEItemStack stack = (IAEItemStack)input;
            IStorageCell<?> type = EStorageCellInventory.getStorageCell(stack.getDefinition());
            return type != null && !type.storableInStorageCell();
        }
        return false;
    }

    private static IStorageCell<?> getStorageCell(ItemStack input) {
        Item type;
        if (input != null && (type = input.func_77973_b()) instanceof IStorageCell) {
            return (IStorageCell)type;
        }
        return null;
    }

    private static boolean isCellEmpty(ICellInventory inv) {
        if (inv != null) {
            return inv.getAvailableItems(inv.getChannel().createList()).isEmpty();
        }
        return true;
    }

    protected IItemList<T> getCellItems() {
        if (this.cellItems == null) {
            this.cellItems = this.channel.createList();
            this.loadCellItems();
        }
        return this.cellItems;
    }

    private void loadCellItems() {
        if (this.cellItems == null) {
            this.cellItems = this.channel.createList();
        }
        this.cellItems.resetStatus();
        long types = this.getStoredItemTypes();
        boolean needsUpdate = false;
        AccessorAbstractCellInventory inv = (AccessorAbstractCellInventory)((Object)this);
        int slot = 0;
        while ((long)slot < types) {
            long stackSize;
            NBTTagCompound compoundTag = inv.getTagCompound().func_74775_l(ITEM_SLOT + slot);
            needsUpdate |= !this.loadCellItem(compoundTag, stackSize = inv.getTagCompound().func_74763_f(ITEM_SLOT_COUNT + slot));
            ++slot;
        }
        if (needsUpdate) {
            this.saveChanges();
        }
    }

    public void persist() {
        AccessorAbstractCellInventory inv = (AccessorAbstractCellInventory)((Object)this);
        if (inv.getIsPersisted()) {
            return;
        }
        NBTTagCompound tagCompound = inv.getTagCompound();
        long itemCount = 0L;
        int x = 0;
        for (IAEStack v : this.cellItems) {
            itemCount += v.getStackSize();
            NBTTagCompound g = new NBTTagCompound();
            v.writeToNBT(g);
            tagCompound.func_74782_a(ITEM_SLOT + x, (NBTBase)g);
            tagCompound.func_74772_a(ITEM_SLOT_COUNT + x, v.getStackSize());
            ++x;
        }
        int oldStoredItems = inv.getStoredItemTypes();
        inv.setStoredItemTypes((short)this.cellItems.size());
        if (this.cellItems.isEmpty()) {
            tagCompound.func_82580_o(ITEM_TYPE_TAG);
        } else {
            tagCompound.func_74777_a(ITEM_TYPE_TAG, inv.getStoredItemTypes());
        }
        inv.setStoredItemCount(itemCount);
        if (itemCount == 0L) {
            tagCompound.func_82580_o(ITEM_COUNT_TAG);
        } else {
            tagCompound.func_74772_a(ITEM_COUNT_TAG, itemCount);
        }
        while (x >= oldStoredItems && x < inv.getMaxItemTypes()) {
            tagCompound.func_82580_o(ITEM_SLOT + x);
            tagCompound.func_82580_o(ITEM_SLOT_COUNT + x);
            ++x;
        }
        inv.setIsPersisted(true);
    }

    public T injectItems(T input, Actionable mode, IActionSource src) {
        long remainingItemCount;
        IAEStack l;
        if (input == null) {
            return null;
        }
        if (input.getStackSize() == 0L) {
            return null;
        }
        if (this.cellType.isBlackListed(this.getItemStack(), input)) {
            return input;
        }
        if (this.isStorageCell(input)) {
            ItemStack cellStack = ((IAEItemStack)input).createItemStack();
            ICellInventoryHandler cellInvHandler = AEApi.instance().registries().cell().getCellInventory(cellStack, null, EStorageCellInventory.getStorageCell(cellStack).getChannel());
            if (cellInvHandler != null && !EStorageCellInventory.isCellEmpty(cellInvHandler.getCellInv())) {
                return input;
            }
        }
        if ((l = this.getCellItems().findPrecise(input)) != null) {
            long remainingItemCount2 = this.getRemainingItemCount();
            if (remainingItemCount2 <= 0L) {
                return input;
            }
            if (input.getStackSize() > remainingItemCount2) {
                IAEStack r = input.copy();
                r.setStackSize(r.getStackSize() - remainingItemCount2);
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(l.getStackSize() + remainingItemCount2);
                    AccessorAbstractCellInventory inv = (AccessorAbstractCellInventory)((Object)this);
                    inv.setStoredItemCount(inv.getStoredItemCount() + remainingItemCount2);
                    this.saveChangesES();
                }
                return (T)r;
            }
            if (mode == Actionable.MODULATE) {
                l.setStackSize(l.getStackSize() + input.getStackSize());
                AccessorAbstractCellInventory inv = (AccessorAbstractCellInventory)((Object)this);
                inv.setStoredItemCount(inv.getStoredItemCount() + input.getStackSize());
                this.saveChangesES();
            }
            return null;
        }
        if (this.canHoldNewItem() && (remainingItemCount = this.getRemainingItemCount() - (long)this.getBytesPerType() * (long)this.itemsPerByte) > 0L) {
            if (input.getStackSize() > remainingItemCount) {
                IAEStack toReturn = input.copy();
                toReturn.setStackSize(input.getStackSize() - remainingItemCount);
                if (mode == Actionable.MODULATE) {
                    IAEStack toWrite = input.copy();
                    toWrite.setStackSize(remainingItemCount);
                    this.cellItems.add(toWrite);
                    this.saveChanges();
                }
                return (T)toReturn;
            }
            if (mode == Actionable.MODULATE) {
                this.cellItems.add(input);
                this.saveChanges();
            }
            return null;
        }
        return input;
    }

    public T extractItems(T request, Actionable mode, IActionSource src) {
        if (request == null) {
            return null;
        }
        long size = Math.min(Integer.MAX_VALUE, request.getStackSize());
        IAEStack results = null;
        IAEStack l = this.getCellItems().findPrecise(request);
        if (l != null) {
            results = l.copy();
            if (l.getStackSize() <= size) {
                results.setStackSize(l.getStackSize());
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(0L);
                    this.saveChanges();
                }
            } else {
                results.setStackSize(size);
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(l.getStackSize() - size);
                    AccessorAbstractCellInventory inv = (AccessorAbstractCellInventory)((Object)this);
                    inv.setStoredItemCount(inv.getStoredItemCount() - results.getStackSize());
                    this.saveChangesES();
                }
            }
        }
        return (T)results;
    }

    public IStorageChannel<T> getChannel() {
        return this.channel;
    }

    protected void saveChangesES() {
        if (this.container != null) {
            ((AccessorAbstractCellInventory)((Object)this)).setIsPersisted(false);
            this.container.saveChanges((ICellInventory)this);
        } else {
            this.saveChanges();
        }
    }

    protected boolean loadCellItem(NBTTagCompound compoundTag, long stackSize) {
        IAEStack t;
        try {
            t = this.channel.createFromNBT(compoundTag);
            if (t == null) {
                AELog.warn((String)("Removing item " + compoundTag + " from storage cell because the associated item type couldn't be found."), (Object[])new Object[0]);
                return false;
            }
        }
        catch (Throwable ex) {
            if (AEConfig.instance().isRemoveCrashingItemsOnLoad()) {
                AELog.warn((Throwable)ex, (String)("Removing item " + compoundTag + " from storage cell because loading the ItemStack crashed."));
                return false;
            }
            throw ex;
        }
        t.setStackSize(stackSize);
        t.setCraftable(false);
        if (stackSize > 0L) {
            this.cellItems.add(t);
        }
        return true;
    }

    public long getUsedBytes() {
        long bytesForItemCount = (this.getStoredItemCount() + (long)this.getUnusedItemCount()) / ((long)this.itemsPerByte * (long)this.cellType.getByteMultiplier());
        return this.getStoredItemTypes() * (long)this.getBytesPerType() + bytesForItemCount;
    }

    public long getRemainingItemCount() {
        long remaining = this.getFreeBytes() * ((long)this.itemsPerByte * (long)this.cellType.getByteMultiplier()) + (long)this.getUnusedItemCount();
        return remaining > 0L ? remaining : 0L;
    }

    public int getUnusedItemCount() {
        int div = (int)(this.getStoredItemCount() % (long)(8 * this.cellType.getByteMultiplier()));
        if (div == 0) {
            return 0;
        }
        return this.itemsPerByte * this.cellType.getByteMultiplier() - div;
    }
}

