/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.estorage;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.storage.MEInventoryHandler;
import github.kasuminova.novaeng.NovaEngineeringCore;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageCellDrive;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageController;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageMEChannel;
import io.netty.util.internal.ThrowableUtil;
import java.util.Collections;
import java.util.List;

public class ECellDriveWatcher<T extends IAEStack<T>>
extends MEInventoryHandler<T> {
    protected final EStorageCellDrive drive;

    public ECellDriveWatcher(IMEInventory<T> i, IStorageChannel<T> channel, EStorageCellDrive drive) {
        super(i, channel);
        this.drive = drive;
    }

    public T injectItems(T input, Actionable type, IActionSource src) {
        long size = input.getStackSize();
        IAEStack remainder = super.injectItems(input, type, src);
        if (type == Actionable.MODULATE && (remainder == null || remainder.getStackSize() != size)) {
            EStorageMEChannel channel = ((EStorageController)((Object)this.drive.getController())).getChannel();
            AENetworkProxy proxy = channel.getProxy();
            if (proxy.isActive()) {
                try {
                    List<IAEStack> changed = Collections.singletonList(input.copy().setStackSize(input.getStackSize() - (remainder == null ? 0L : remainder.getStackSize())));
                    proxy.getStorage().postAlterationOfStoredItems(this.getChannel(), changed, channel.getSource());
                }
                catch (GridAccessException e) {
                    NovaEngineeringCore.log.warn(ThrowableUtil.stackTraceToString((Throwable)e));
                }
            }
            this.drive.onWriting();
        }
        return (T)remainder;
    }

    public T extractItems(T request, Actionable type, IActionSource src) {
        IAEStack extractable = super.extractItems(request, type, src);
        if (type == Actionable.MODULATE && extractable != null) {
            EStorageMEChannel channel = ((EStorageController)((Object)this.drive.getController())).getChannel();
            AENetworkProxy proxy = channel.getProxy();
            if (proxy.isActive()) {
                try {
                    List<IAEStack> changed = Collections.singletonList(request.copy().setStackSize(-extractable.getStackSize()));
                    proxy.getStorage().postAlterationOfStoredItems(this.getChannel(), changed, channel.getSource());
                }
                catch (GridAccessException e) {
                    NovaEngineeringCore.log.warn(ThrowableUtil.stackTraceToString((Throwable)e));
                }
            }
            this.drive.onWriting();
        }
        return (T)extractable;
    }

    public boolean isSticky() {
        IMEInventory iMEInventory = this.getInternal();
        if (iMEInventory instanceof ICellInventoryHandler) {
            ICellInventoryHandler cellInventoryHandler = (ICellInventoryHandler)iMEInventory;
            return cellInventoryHandler.isSticky();
        }
        return super.isSticky();
    }
}

