/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.crafttweaker.util;

import crafttweaker.annotations.ZenRegister;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="novaeng.NovaEngUtils")
public class NovaEngUtils {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#,###.##");

    @ZenMethod
    public static String formatFloat(float value, int decimalFraction) {
        return NovaEngUtils.formatDouble(value, decimalFraction);
    }

    @ZenMethod
    public static String formatDouble(double value, int decimalFraction) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(decimalFraction);
        return nf.format(value);
    }

    @ZenMethod
    public static String formatDecimal(double value) {
        return DECIMAL_FORMAT.format(value);
    }

    @ZenMethod
    public static String formatNumber(long value) {
        if (value < 1000L) {
            return String.valueOf(value);
        }
        if (value < 1000000L) {
            return NovaEngUtils.formatFloat((float)value / 1000.0f, 2) + "K";
        }
        if (value < 1000000000L) {
            return NovaEngUtils.formatDouble((double)value / 1000000.0, 2) + "M";
        }
        if (value < 1000000000000L) {
            return NovaEngUtils.formatDouble((double)value / 1.0E9, 2) + "G";
        }
        if (value < 1000000000000000L) {
            return NovaEngUtils.formatDouble((double)value / 1.0E12, 2) + "T";
        }
        if (value < 1000000000000000000L) {
            return NovaEngUtils.formatDouble((double)value / 1.0E15, 2) + "P";
        }
        return NovaEngUtils.formatDouble((double)value / 1.0E18, 2) + "E";
    }

    @ZenMethod
    public static String formatNumber(long value, int decimalFraction) {
        if (value < 1000L) {
            return String.valueOf(value);
        }
        if (value < 1000000L) {
            return NovaEngUtils.formatFloat((float)value / 1000.0f, decimalFraction) + "K";
        }
        if (value < 1000000000L) {
            return NovaEngUtils.formatDouble((double)value / 1000000.0, decimalFraction) + "M";
        }
        if (value < 1000000000000L) {
            return NovaEngUtils.formatDouble((double)value / 1.0E9, decimalFraction) + "G";
        }
        if (value < 1000000000000000L) {
            return NovaEngUtils.formatDouble((double)value / 1.0E12, decimalFraction) + "T";
        }
        if (value < 1000000000000000000L) {
            return NovaEngUtils.formatDouble((double)value / 1.0E15, decimalFraction) + "P";
        }
        return NovaEngUtils.formatDouble((double)value / 1.0E18, decimalFraction) + "E";
    }

    @ZenMethod
    public static String formatPercent(double num1, double num2) {
        return NovaEngUtils.formatDouble(num1 / num2 * 100.0, 2) + "%";
    }

    @ZenMethod
    public static String formatFLOPS(double value) {
        if (value < 1000.0) {
            return NovaEngUtils.formatDouble(value, 1) + "T FloPS";
        }
        return NovaEngUtils.formatDouble(value / 1000.0, 1) + "P FloPS";
    }

    static {
        DECIMAL_FORMAT.setRoundingMode(RoundingMode.HALF_UP);
    }
}

