/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.crafttweaker.hypernet.server;

import crafttweaker.annotations.ZenRegister;
import github.kasuminova.novaeng.NovaEngineeringCore;
import github.kasuminova.novaeng.client.model.ItemModelFileAutoGenerator;
import github.kasuminova.novaeng.common.hypernet.computer.module.base.ServerModuleBase;
import github.kasuminova.novaeng.common.item.ItemServerModule;
import github.kasuminova.novaeng.common.registry.RegistryItems;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="novaeng.hypernet.item.ServerModuleItemBuilder")
public class ServerModuleItemBuilder {
    protected final String registryName;
    protected ServerModuleBase<?> boundedModule = null;
    protected int stackSize = 1;

    public ServerModuleItemBuilder(String registryName) {
        this.registryName = registryName;
    }

    @ZenMethod
    public static ServerModuleItemBuilder create(String registryName) {
        return new ServerModuleItemBuilder(registryName);
    }

    @ZenMethod
    public int getStackSize() {
        return this.stackSize;
    }

    @ZenMethod
    public ServerModuleItemBuilder setStackSize(int stackSize) {
        this.stackSize = stackSize;
        return this;
    }

    @ZenMethod
    public ServerModuleBase<?> getBoundedModule() {
        return this.boundedModule;
    }

    @ZenMethod
    public ServerModuleItemBuilder setBoundedModule(ServerModuleBase<?> boundedModule) {
        this.boundedModule = boundedModule;
        return this;
    }

    @ZenMethod
    public void register() {
        RegistryItems.ITEMS_TO_REGISTER_CT.add(new ItemServerModule(this.registryName, this.boundedModule).func_77625_d(this.stackSize));
    }

    @ZenMethod
    public void registerWithCustomModelPath(String modelPath) {
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        try {
            ItemModelFileAutoGenerator.generate(resourceManager, modelPath);
        }
        catch (IOException e) {
            NovaEngineeringCore.log.warn("Failed to auto generate item model resource {}, May cause invalid texture.", (Object)modelPath);
            NovaEngineeringCore.log.warn((Object)e);
        }
        RegistryItems.CUSTOM_MODEL_ITEMS_TO_REGISTER_CT.put(modelPath, new ItemServerModule(this.registryName, this.boundedModule).func_77625_d(this.stackSize));
    }
}

