/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.crafttweaker.hypernet.server;

import crafttweaker.annotations.ZenRegister;
import github.kasuminova.novaeng.NovaEngineeringCore;
import github.kasuminova.novaeng.client.model.ItemModelFileAutoGenerator;
import github.kasuminova.novaeng.common.item.ItemModularServer;
import github.kasuminova.novaeng.common.registry.RegistryItems;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="novaeng.hypernet.item.ModularServerItemBuilder")
public class ModularServerItemBuilder {
    protected final String registryName;

    public ModularServerItemBuilder(String registryName) {
        this.registryName = registryName;
    }

    @ZenMethod
    public static ModularServerItemBuilder create(String registryName) {
        return new ModularServerItemBuilder(registryName);
    }

    @ZenMethod
    public void register() {
        RegistryItems.ITEMS_TO_REGISTER_CT.add(new ItemModularServer(this.registryName));
    }

    @ZenMethod
    public void registerWithCustomModelPath(String modelPath) {
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        try {
            ItemModelFileAutoGenerator.generate(resourceManager, modelPath);
        }
        catch (IOException e) {
            NovaEngineeringCore.log.warn("Failed to auto generate item model resource {}, May cause invalid texture.", (Object)modelPath);
            NovaEngineeringCore.log.warn((Object)e);
        }
        RegistryItems.CUSTOM_MODEL_ITEMS_TO_REGISTER_CT.put(modelPath, new ItemModularServer(this.registryName));
    }
}

