/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.crafttweaker.hypernet;

import crafttweaker.annotations.ZenRegister;
import github.kasuminova.mmce.common.event.client.ControllerGUIRenderEvent;
import github.kasuminova.mmce.common.helper.IMachineController;
import github.kasuminova.novaeng.common.crafttweaker.util.NovaEngUtils;
import github.kasuminova.novaeng.common.hypernet.old.ComputationCenter;
import github.kasuminova.novaeng.common.hypernet.old.ComputationCenterCache;
import github.kasuminova.novaeng.common.hypernet.old.NetNodeCache;
import github.kasuminova.novaeng.common.hypernet.old.NetNodeImpl;
import github.kasuminova.novaeng.common.hypernet.old.misc.HyperNetConnectCardInfo;
import github.kasuminova.novaeng.common.registry.RegistryHyperNet;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.event.MMEvents;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="novaeng.hypernet.HyperNetHelper")
public class HyperNetHelper {
    @ZenMethod
    public static void proxyMachineForHyperNet(String machineName) {
        HyperNetHelper.proxyMachineForHyperNet(new ResourceLocation("modularmachinery", machineName));
    }

    public static void proxyMachineForHyperNet(ResourceLocation registryName) {
        RegistryHyperNet.registerHyperNetNode(registryName, NetNodeImpl.class);
        MMEvents.WAIT_FOR_MODIFY.add(() -> {
            DynamicMachine machine = MachineRegistry.getRegistry().getMachine(registryName);
            if (machine != null) {
                HyperNetHelper.addControllerGUIHyperNetInfo(machine, NetNodeImpl.class);
            }
        });
    }

    public static <T extends NetNodeImpl> void addControllerGUIHyperNetInfo(DynamicMachine machine, Class<T> netNodeType) {
        if (!FMLCommonHandler.instance().getSide().isClient()) {
            return;
        }
        machine.addMachineEventHandler(ControllerGUIRenderEvent.class, event -> {
            TileMultiblockMachineController ctrl = event.getController();
            NetNodeImpl node = (NetNodeImpl)NetNodeCache.getCache(ctrl, netNodeType);
            if (node == null) {
                return;
            }
            if (ctrl.getTicksExisted() % 20 == 0) {
                node.readNBT();
            }
            ArrayList<String> tips = new ArrayList<String>();
            tips.add(I18n.func_135052_a((String)"gui.hypernet.controller.title", (Object[])new Object[0]));
            if (node.isConnected()) {
                tips.add(I18n.func_135052_a((String)"gui.hypernet.controller.connected", (Object[])new Object[0]));
                tips.add(I18n.func_135052_a((String)"gui.hypernet.controller.computation_point_consumption.total", (Object[])new Object[]{NovaEngUtils.formatFLOPS(ComputationCenterCache.getComputationPointConsumption()), NovaEngUtils.formatFLOPS(ComputationCenterCache.getComputationPointGeneration())}));
                if (node.isWorking()) {
                    tips.add(I18n.func_135052_a((String)"gui.hypernet.controller.computation_point_consumption", (Object[])new Object[0]) + NovaEngUtils.formatFLOPS(node.getComputationPointConsumption()));
                }
            } else {
                tips.add(I18n.func_135052_a((String)"gui.hypernet.controller.disconnected", (Object[])new Object[0]));
            }
            event.setExtraInfo(tips.toArray(new String[0]));
        });
    }

    public static boolean supportsHyperNet(TileMultiblockMachineController ctrl) {
        return RegistryHyperNet.isHyperNetSupported(ctrl.getFoundMachine());
    }

    public static boolean isComputationCenter(TileMultiblockMachineController ctrl) {
        DynamicMachine foundMachine = ctrl.getFoundMachine();
        if (foundMachine == null) {
            return false;
        }
        return RegistryHyperNet.isComputationCenter(foundMachine.getRegistryName());
    }

    public static void writeConnectCardInfo(ComputationCenter center, UUID networkOwner, ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74772_a("pos", center.getOwner().func_174877_v().func_177986_g());
        tag.func_74778_a("owner", networkOwner.toString());
        stack.func_77982_d(tag);
    }

    public static boolean isValidConnectCard(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null && tag.func_74764_b("pos") && tag.func_74764_b("owner");
    }

    public static HyperNetConnectCardInfo readConnectCardInfo(IMachineController ctrl, ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b("pos") || !tag.func_74764_b("owner")) {
            return null;
        }
        BlockPos pos = BlockPos.func_177969_a((long)tag.func_74763_f("pos"));
        World world = ctrl.getController().func_145831_w();
        if (!world.func_175667_e(pos)) {
            return null;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileMultiblockMachineController)) {
            return null;
        }
        TileMultiblockMachineController center = (TileMultiblockMachineController)te;
        if (!HyperNetHelper.isComputationCenter(center)) {
            return null;
        }
        UUID networkOwner = UUID.fromString(tag.func_74779_i("owner"));
        return new HyperNetConnectCardInfo(pos, networkOwner);
    }
}

