/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.crafttweaker.expansion;

import crafttweaker.annotations.ZenRegister;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeStartEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeTickEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeCheckEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeStartEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeTickEvent;
import github.kasuminova.novaeng.common.crafttweaker.util.NovaEngUtils;
import github.kasuminova.novaeng.common.hypernet.old.NetNodeCache;
import github.kasuminova.novaeng.common.hypernet.old.NetNodeImpl;
import github.kasuminova.novaeng.common.hypernet.old.research.ResearchCognitionData;
import github.kasuminova.novaeng.common.registry.RegistryHyperNet;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.RecipePrimer;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenExpansion(value="mods.modularmachinery.RecipePrimer")
public class RecipePrimerHyperNet {
    @ZenMethod
    public static RecipePrimer requireComputationPoint(RecipePrimer primer, float required) {
        return RecipePrimerHyperNet.requireComputationPoint(primer, required, false);
    }

    @ZenMethod
    public static RecipePrimer requireComputationPoint(RecipePrimer primer, float required, boolean triggerFailure) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            primer.addRecipeTooltip(new String[]{I18n.func_135052_a((String)"novaeng.hypernet.computation_point_required.tip", (Object[])new Object[]{NovaEngUtils.formatFLOPS(required)}).intern()});
        }
        return primer.addPostCheckHandler(event -> {
            TileMultiblockMachineController ctrl = event.getController();
            NetNodeImpl node = NetNodeCache.getCache(ctrl, NetNodeImpl.class);
            if (node != null) {
                node.checkComputationPoint((RecipeCheckEvent)event, required, new ResearchCognitionData[0]);
            }
        }).addStartHandler(event -> {
            TileMultiblockMachineController ctrl = event.getController();
            NetNodeImpl node = NetNodeCache.getCache(ctrl, NetNodeImpl.class);
            if (node != null) {
                node.onRecipeStart((RecipeStartEvent)event, (double)required);
            }
        }).addFactoryStartHandler(event -> {
            TileMultiblockMachineController ctrl = event.getController();
            NetNodeImpl node = NetNodeCache.getCache(ctrl, NetNodeImpl.class);
            if (node != null) {
                node.onRecipeStart((FactoryRecipeStartEvent)event, (double)required);
            }
        }).addPreTickHandler(event -> {
            TileMultiblockMachineController ctrl = event.getController();
            NetNodeImpl node = NetNodeCache.getCache(ctrl, NetNodeImpl.class);
            if (node != null) {
                node.onRecipePreTick((RecipeTickEvent)event, (double)required, triggerFailure);
            }
        }).addFactoryPreTickHandler(event -> {
            TileMultiblockMachineController ctrl = event.getController();
            NetNodeImpl node = NetNodeCache.getCache(ctrl, NetNodeImpl.class);
            if (node != null) {
                node.onRecipePreTick((FactoryRecipeTickEvent)event, (double)required, triggerFailure);
            }
        }).addFactoryFinishHandler(event -> {
            TileMultiblockMachineController ctrl = event.getController();
            NetNodeImpl node = NetNodeCache.getCache(ctrl, NetNodeImpl.class);
            if (node != null) {
                node.onRecipeFinished(event.getRecipeThread());
            }
        }).addFinishHandler(event -> {
            TileMultiblockMachineController ctrl = event.getController();
            NetNodeImpl node = NetNodeCache.getCache(ctrl, NetNodeImpl.class);
            if (node != null) {
                node.onRecipeFinished(event.getRecipeThread());
            }
        });
    }

    @ZenMethod
    public static RecipePrimer requireResearch(RecipePrimer primer, String ... researchNames) {
        return RecipePrimerHyperNet.requireResearch(primer, (ResearchCognitionData[])Arrays.stream(researchNames).map(RegistryHyperNet::getResearchCognitionData).filter(Objects::nonNull).toArray(ResearchCognitionData[]::new));
    }

    @ZenMethod
    public static RecipePrimer requireResearch(RecipePrimer primer, ResearchCognitionData ... researchRequired) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            String researchTip = Arrays.stream(researchRequired).map(ResearchCognitionData::getTranslatedName).collect(Collectors.joining(TextFormatting.RESET + ", "));
            primer.addRecipeTooltip(new String[]{I18n.func_135052_a((String)"novaeng.hypernet.research_required.tip", (Object[])new Object[]{researchTip}).intern()});
        }
        return primer.addPostCheckHandler(event -> {
            NetNodeImpl cache = NetNodeCache.getCache(event.getController(), NetNodeImpl.class);
            if (cache != null) {
                cache.checkResearch((RecipeCheckEvent)event, researchRequired);
            }
        });
    }
}

