/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.crafttweaker.expansion;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeFailureEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeFinishEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeTickEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeCheckEvent;
import github.kasuminova.novaeng.common.hypernet.old.NetNodeCache;
import github.kasuminova.novaeng.common.hypernet.old.machine.AssemblyLine;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.RecipeBuilder;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.RecipePrimer;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenExpansion(value="mods.modularmachinery.RecipePrimer")
public class RecipePrimerAssemblyLine {
    public static final ResourceLocation ASSEMBLY_LINE = new ResourceLocation("modularmachinery", "assembly_line");

    @ZenMethod
    public static RecipePrimer setAssemblyLineProxied(RecipePrimer primer) {
        ResourceLocation machineName = primer.getParentMachineName();
        if (!machineName.equals((Object)ASSEMBLY_LINE)) {
            CraftTweakerAPI.logError((String)("Cannot proxy AssemblyLine recipe for `" + primer.getRecipeRegistryName() + "`, because parent machine is not `assembly_line`!"));
            return primer;
        }
        return primer.addPostCheckHandler(event -> {
            if (AssemblyLine.isNotAssemblyLine(event.getController())) {
                return;
            }
            AssemblyLine assemblyLine = NetNodeCache.getCache(event.getController(), AssemblyLine.class);
            if (assemblyLine != null) {
                assemblyLine.onAssemblyLineRecipeCheck((RecipeCheckEvent)event);
            }
        }).addFactoryPreTickHandler(event -> {
            if (AssemblyLine.isNotAssemblyLine(event.getController())) {
                return;
            }
            AssemblyLine assemblyLine = NetNodeCache.getCache(event.getController(), AssemblyLine.class);
            if (assemblyLine != null) {
                assemblyLine.onAssemblyLineRecipePreTick((FactoryRecipeTickEvent)event);
            }
        }).addFactoryPostTickHandler(event -> {
            if (AssemblyLine.isNotAssemblyLine(event.getController())) {
                return;
            }
            AssemblyLine assemblyLine = NetNodeCache.getCache(event.getController(), AssemblyLine.class);
            if (assemblyLine != null) {
                assemblyLine.onAssemblyLineRecipePostTick((FactoryRecipeTickEvent)event);
            }
        }).addFactoryFinishHandler(event -> {
            if (AssemblyLine.isNotAssemblyLine(event.getController())) {
                return;
            }
            AssemblyLine assemblyLine = NetNodeCache.getCache(event.getController(), AssemblyLine.class);
            if (assemblyLine != null) {
                assemblyLine.onAssemblyLineRecipeFinished((FactoryRecipeFinishEvent)event);
            }
        }).addFactoryFailureHandler(event -> {
            if (AssemblyLine.isNotAssemblyLine(event.getController())) {
                return;
            }
            AssemblyLine assemblyLine = NetNodeCache.getCache(event.getController(), AssemblyLine.class);
            if (assemblyLine != null) {
                assemblyLine.onAssemblyLineRecipeFailure((FactoryRecipeFailureEvent)event);
            }
        });
    }

    @ZenMethod
    public static RecipePrimer convertAssemblyLineRecipeToDefaultRecipeAndRegister(RecipePrimer primer, String machineName) {
        String recipeName = primer.getRecipeRegistryName().func_110623_a() + ".copy." + machineName;
        RecipePrimer newPrimer = RecipeBuilder.newBuilder((String)recipeName, (String)machineName, (int)primer.getTotalProcessingTickTime(), (int)primer.getPriority(), (boolean)primer.voidPerTickFailure());
        List components = newPrimer.getComponents();
        for (ComponentRequirement component : primer.getComponents()) {
            ComponentRequirement copied = component.deepCopy().postDeepCopy(component);
            copied.setTag(null);
            components.add(copied);
        }
        newPrimer.getRecipeEventHandlers().putAll(primer.getRecipeEventHandlers());
        newPrimer.getTooltipList().addAll(primer.getTooltipList());
        newPrimer.build();
        return primer;
    }
}

