/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.container.slot;

import github.kasuminova.novaeng.common.util.TileItemHandler;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public abstract class SlotConditionItemHandler
extends SlotItemHandler {
    protected final int displayID;
    protected boolean enabled = false;
    protected boolean hovered = false;
    protected final List<SlotConditionItemHandler> dependencies = new LinkedList<SlotConditionItemHandler>();
    protected final List<SlotConditionItemHandler> dependents = new LinkedList<SlotConditionItemHandler>();
    protected final List<SlotConditionItemHandler> softDependents = new LinkedList<SlotConditionItemHandler>();
    protected final List<SlotConditionItemHandler> softDependencies = new LinkedList<SlotConditionItemHandler>();

    public SlotConditionItemHandler(TileItemHandler inventoryIn, int index, int displayID) {
        super((IItemHandler)inventoryIn, index, 0, 0);
        this.displayID = displayID;
    }

    public boolean func_82869_a(EntityPlayer playerIn) {
        for (SlotConditionItemHandler dependent : this.dependents) {
            if (!dependent.isInstalled()) continue;
            return false;
        }
        return super.func_82869_a(playerIn);
    }

    public SlotConditionItemHandler dependsOn(SlotConditionItemHandler dependency) {
        if (this == dependency) {
            throw new IllegalArgumentException("Cannot add self as dependency!");
        }
        if (this.dependents.contains((Object)dependency)) {
            throw new IllegalArgumentException("Circular dependency!");
        }
        if (!this.dependencies.contains((Object)this)) {
            this.dependencies.add(dependency);
            dependency.addDependent(this);
        }
        return this;
    }

    public SlotConditionItemHandler softDependsOn(SlotConditionItemHandler softDependency) {
        if (this == softDependency) {
            throw new IllegalArgumentException("Cannot add self as soft dependency!");
        }
        if (this.softDependents.contains((Object)softDependency)) {
            throw new IllegalArgumentException("Circular soft dependency!");
        }
        if (!this.softDependencies.contains((Object)softDependency)) {
            this.softDependencies.add(softDependency);
            softDependency.addSoftDependent(this);
        }
        return this;
    }

    protected void addDependent(SlotConditionItemHandler dependent) {
        this.dependents.add(dependent);
    }

    protected void addSoftDependent(SlotConditionItemHandler dependent) {
        this.softDependents.add(dependent);
    }

    public boolean isInstalled() {
        return this.func_75216_d() && this.func_75214_a(this.func_75211_c());
    }

    public boolean isAvailable() {
        for (SlotConditionItemHandler dependency : this.dependencies) {
            if (dependency.isInstalled()) continue;
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getHoverTooltips() {
        String slotDesc = this.getSlotDescription();
        LinkedList<String> tooltips = new LinkedList<String>();
        tooltips.add(slotDesc);
        if (this.isInvalid()) {
            tooltips.add(I18n.func_135052_a((String)"gui.modular_server_assembler.assembly.invalid", (Object[])new Object[0]));
            return tooltips;
        }
        if (!this.dependencies.isEmpty()) {
            tooltips.add(I18n.func_135052_a((String)"gui.modular_server_assembler.assembly.dependencies", (Object[])new Object[0]));
            for (SlotConditionItemHandler dependency : this.dependencies) {
                if (dependency.isInstalled()) {
                    tooltips.add(dependency.getSlotDescription() + I18n.func_135052_a((String)"gui.modular_server_assembler.assembly.dependencies.installed", (Object[])new Object[0]));
                    continue;
                }
                tooltips.add(dependency.getSlotDescription() + I18n.func_135052_a((String)"gui.modular_server_assembler.assembly.dependencies.uninstalled", (Object[])new Object[0]));
            }
        }
        if (!this.dependents.isEmpty()) {
            tooltips.add(I18n.func_135052_a((String)"gui.modular_server_assembler.assembly.dependents", (Object[])new Object[0]));
            for (SlotConditionItemHandler dependent : this.dependents) {
                tooltips.add(dependent.getSlotDescription());
            }
        }
        if (!this.softDependencies.isEmpty()) {
            tooltips.add(I18n.func_135052_a((String)"gui.modular_server_assembler.assembly.soft_dependencies", (Object[])new Object[0]));
            for (SlotConditionItemHandler dependency : this.softDependencies) {
                if (dependency.isInstalled()) {
                    tooltips.add(dependency.getSlotDescription() + I18n.func_135052_a((String)"gui.modular_server_assembler.assembly.dependencies.installed", (Object[])new Object[0]));
                    continue;
                }
                tooltips.add(dependency.getSlotDescription() + I18n.func_135052_a((String)"gui.modular_server_assembler.assembly.dependencies.uninstalled", (Object[])new Object[0]));
            }
        }
        if (!this.softDependents.isEmpty()) {
            tooltips.add(I18n.func_135052_a((String)"gui.modular_server_assembler.assembly.soft_dependents", (Object[])new Object[0]));
            for (SlotConditionItemHandler dependent : this.softDependents) {
                tooltips.add(dependent.getSlotDescription());
            }
        }
        return tooltips;
    }

    public abstract String getSlotDescription();

    public List<SlotConditionItemHandler> getDependencies() {
        return this.dependencies;
    }

    public List<SlotConditionItemHandler> getDependents() {
        return this.dependents;
    }

    public List<SlotConditionItemHandler> getSoftDependents() {
        return this.softDependents;
    }

    public List<SlotConditionItemHandler> getSoftDependencies() {
        return this.softDependencies;
    }

    public TileItemHandler getItemHandler() {
        return (TileItemHandler)super.getItemHandler();
    }

    public boolean isInvalid() {
        ItemStack stackInSlot = this.func_75211_c();
        return !stackInSlot.func_190926_b() && !this.func_75214_a(stackInSlot);
    }

    public boolean isHovered() {
        return this.hovered;
    }

    public SlotConditionItemHandler setHovered(boolean hovered) {
        this.hovered = hovered;
        return this;
    }

    public boolean func_111238_b() {
        return this.enabled;
    }

    public SlotConditionItemHandler setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }
}

