/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.container.slot;

import github.kasuminova.novaeng.common.container.ContainerModularServerAssembler;
import github.kasuminova.novaeng.common.container.slot.SlotCPUExtItemHandler;
import github.kasuminova.novaeng.common.container.slot.SlotCPUHeatRadiatorItemHandler;
import github.kasuminova.novaeng.common.container.slot.SlotCPUItemHandler;
import github.kasuminova.novaeng.common.container.slot.SlotCalculateCardExtItemHandler;
import github.kasuminova.novaeng.common.container.slot.SlotCalculateCardHeatRadiatorItemHandler;
import github.kasuminova.novaeng.common.container.slot.SlotCalculateCardItemHandler;
import github.kasuminova.novaeng.common.container.slot.SlotCapacitorItemHandler;
import github.kasuminova.novaeng.common.container.slot.SlotConditionItemHandler;
import github.kasuminova.novaeng.common.container.slot.SlotExtensionCardExtItemHandler;
import github.kasuminova.novaeng.common.container.slot.SlotExtensionCardHeatRadiatorItemHandler;
import github.kasuminova.novaeng.common.container.slot.SlotExtensionCardItemHandler;
import github.kasuminova.novaeng.common.container.slot.SlotPSUItemHandler;
import github.kasuminova.novaeng.common.container.slot.SlotRAMHeatRadiatorItemHandler;
import github.kasuminova.novaeng.common.container.slot.SlotRAMItemHandler;
import github.kasuminova.novaeng.common.hypernet.computer.ModularServer;
import github.kasuminova.novaeng.common.util.TileItemHandler;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.inventory.Slot;

public class AssemblySlotManager {
    private final ModularServer modularServer;
    private final Map<String, Int2ObjectMap<SlotConditionItemHandler>> inventorySlots = new HashMap<String, Int2ObjectMap<SlotConditionItemHandler>>();

    public AssemblySlotManager(ModularServer modularServer) {
        this.modularServer = modularServer;
    }

    public void initSlots() {
        this.addCPUSlots();
        this.addCalculateCardSlots();
        this.addExtensionCardSlots();
        this.addPowerSlots();
    }

    protected void addCPUSlots() {
        int i;
        TileItemHandler invCPU = this.modularServer.getInvByName("cpu");
        SlotCPUExtItemHandler ext_2 = this.addSlot(new SlotCPUExtItemHandler(20, invCPU));
        for (i = 0; i < 2; ++i) {
            this.addSlot(new SlotCPUItemHandler(i, i, invCPU)).softDependsOn(this.addSlot(new SlotCPUHeatRadiatorItemHandler(i, 21 + i, invCPU)));
        }
        for (i = 0; i < 2; ++i) {
            this.addSlot(new SlotCPUItemHandler(2 + i, 2 + i, invCPU)).softDependsOn(this.addSlot(new SlotCPUHeatRadiatorItemHandler(2 + i, 23 + i, invCPU)).dependsOn(ext_2)).dependsOn(ext_2);
        }
        for (i = 0; i < 8; ++i) {
            this.addSlot(new SlotRAMItemHandler(i, 4 + i, invCPU)).softDependsOn(this.addSlot(new SlotRAMHeatRadiatorItemHandler(i, 25 + i, invCPU)));
        }
        for (i = 0; i < 8; ++i) {
            this.addSlot(new SlotRAMItemHandler(8 + i, 12 + i, invCPU)).softDependsOn(this.addSlot(new SlotRAMHeatRadiatorItemHandler(8 + i, 33 + i, invCPU)).dependsOn(ext_2)).dependsOn(ext_2);
        }
    }

    protected void addCalculateCardSlots() {
        TileItemHandler invCalculateCard = this.modularServer.getInvByName("calculate_card");
        for (int extSlotID = 0; extSlotID < 4; ++extSlotID) {
            SlotCalculateCardExtItemHandler calculateCardExt = this.addSlot(new SlotCalculateCardExtItemHandler(extSlotID, 8 + extSlotID, invCalculateCard));
            for (int slotID = 0; slotID < 2; ++slotID) {
                int id = extSlotID * 2 + slotID;
                this.addSlot(new SlotCalculateCardItemHandler(id, id, invCalculateCard).softDependsOn(this.addSlot(new SlotCalculateCardHeatRadiatorItemHandler(id, 12 + id, invCalculateCard)).dependsOn(calculateCardExt))).dependsOn(calculateCardExt);
            }
        }
    }

    protected void addExtensionCardSlots() {
        TileItemHandler invExtensionCard = this.modularServer.getInvByName("extension");
        for (int extSlotID = 0; extSlotID < 4; ++extSlotID) {
            SlotExtensionCardExtItemHandler calculateCardExt = this.addSlot(new SlotExtensionCardExtItemHandler(extSlotID, 16 + extSlotID, invExtensionCard));
            for (int slotID = 0; slotID < 4; ++slotID) {
                int id = extSlotID * 4 + slotID;
                this.addSlot(new SlotExtensionCardItemHandler(id, id, invExtensionCard).softDependsOn(this.addSlot(new SlotExtensionCardHeatRadiatorItemHandler(id, 20 + id, invExtensionCard)).dependsOn(calculateCardExt))).dependsOn(calculateCardExt);
            }
        }
    }

    protected void addPowerSlots() {
        int slotID;
        TileItemHandler invPower = this.modularServer.getInvByName("power");
        for (slotID = 0; slotID < 4; ++slotID) {
            this.addSlot(new SlotPSUItemHandler(slotID, slotID, invPower));
        }
        for (slotID = 0; slotID < 4; ++slotID) {
            this.addSlot(new SlotCapacitorItemHandler(slotID, 4 + slotID, invPower));
        }
    }

    public <SLOT extends SlotConditionItemHandler> SLOT addSlot(@Nonnull SLOT slot) {
        TileItemHandler inv = slot.getItemHandler();
        int slotID = slot.getSlotIndex();
        this.inventorySlots.computeIfAbsent(inv.getInvName(), v -> new Int2ObjectOpenHashMap()).put(slotID, slot);
        return slot;
    }

    public void addSlot(@Nonnull SlotConditionItemHandler slot, @Nonnull TileItemHandler tileItemHandler, @Nonnull String invName, int slotId) {
        if (tileItemHandler.isSlotAvailable(slotId)) {
            this.inventorySlots.computeIfAbsent(invName, v -> new Int2ObjectOpenHashMap()).put(slotId, (Object)slot);
        }
    }

    public void addAllSlotToContainer(ContainerModularServerAssembler container) {
        for (Int2ObjectMap<SlotConditionItemHandler> invSlots : this.inventorySlots.values()) {
            for (SlotConditionItemHandler slot : invSlots.values()) {
                container.func_75146_a((Slot)slot);
            }
        }
    }

    public SlotConditionItemHandler getSlot(@Nonnull String invName, int slotId) {
        SlotConditionItemHandler slot;
        Int2ObjectMap<SlotConditionItemHandler> invSlots = this.inventorySlots.get(invName);
        if (invSlots != null && (slot = (SlotConditionItemHandler)((Object)invSlots.get(slotId))).getItemHandler().isSlotAvailable(slotId)) {
            return slot;
        }
        return null;
    }
}

