/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.container.data;

import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.data.IAEItemStack;
import appeng.tile.inventory.AppEngCellInventory;
import github.kasuminova.novaeng.common.block.ecotech.estorage.prop.DriveStorageLevel;
import github.kasuminova.novaeng.common.block.ecotech.estorage.prop.DriveStorageType;
import github.kasuminova.novaeng.common.estorage.ECellDriveWatcher;
import github.kasuminova.novaeng.common.estorage.EStorageCellHandler;
import github.kasuminova.novaeng.common.item.estorage.EStorageCell;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageCellDrive;
import java.util.Objects;
import net.minecraft.item.ItemStack;

public final class EStorageCellData {
    private final DriveStorageType type;
    private final DriveStorageLevel level;
    private final int usedTypes;
    private final long usedBytes;

    public EStorageCellData(DriveStorageType type, DriveStorageLevel level, int usedTypes, long usedBytes) {
        this.type = type;
        this.level = level;
        this.usedTypes = usedTypes;
        this.usedBytes = usedBytes;
    }

    public static EStorageCellData from(EStorageCellDrive drive) {
        AppEngCellInventory driveInv = drive.getDriveInv();
        ItemStack stack = driveInv.getStackInSlot(0);
        if (stack.func_190926_b()) {
            return null;
        }
        EStorageCellHandler handler = EStorageCellHandler.getHandler(stack);
        if (handler == null) {
            return null;
        }
        EStorageCell cell = (EStorageCell)stack.func_77973_b();
        DriveStorageType type = EStorageCellDrive.getCellType(cell);
        if (type == null) {
            return null;
        }
        DriveStorageLevel level = cell.getLevel();
        ECellDriveWatcher<IAEItemStack> watcher = drive.getWatcher();
        if (watcher == null) {
            return null;
        }
        ICellInventoryHandler cellInventory = (ICellInventoryHandler)watcher.getInternal();
        if (cellInventory == null) {
            return null;
        }
        ICellInventory cellInv = cellInventory.getCellInv();
        if (cellInv == null) {
            return null;
        }
        long storedTypes = cellInv.getStoredItemTypes();
        long usedBytes = cellInv.getUsedBytes();
        return new EStorageCellData(type, level, (int)storedTypes, usedBytes);
    }

    public String toString() {
        return "EStorageCellData[" + "type=" + (Object)((Object)this.type) + "," + "level=" + (Object)((Object)this.level) + "," + "usedTypes=" + this.usedTypes + "," + "usedBytes=" + this.usedBytes + "]";
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.level != null ? this.level.hashCode() : 0);
        result = 31 * result + this.usedTypes;
        result = 31 * result + (int)(this.usedBytes ^ this.usedBytes >>> 32);
        return result;
    }

    public final boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 == null) {
            return false;
        }
        if (arg0.getClass() != this.getClass()) {
            return false;
        }
        if (!Objects.equals((Object)((EStorageCellData)arg0).type, (Object)this.type)) {
            return false;
        }
        if (!Objects.equals((Object)((EStorageCellData)arg0).level, (Object)this.level)) {
            return false;
        }
        if (((EStorageCellData)arg0).usedTypes != this.usedTypes) {
            return false;
        }
        return ((EStorageCellData)arg0).usedBytes == this.usedBytes;
        {
        }
    }

    public DriveStorageType type() {
        return this.type;
    }

    public DriveStorageLevel level() {
        return this.level;
    }

    public int usedTypes() {
        return this.usedTypes;
    }

    public long usedBytes() {
        return this.usedBytes;
    }
}

