/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.container.data;

import github.kasuminova.novaeng.common.block.ecotech.efabricator.prop.Levels;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public final class EFabricatorData {
    private final int length;
    private final boolean overclocked;
    private final boolean activeCooling;
    private final int maxParallelism;
    private final int coolant;
    private final int maxCoolant;
    private final int hotCoolant;
    private final int maxHotCoolant;
    private final int energyStored;
    private final long totalCrafted;
    private final Levels level;
    private final List<WorkerStatus> workers;

    public EFabricatorData(int length, boolean overclocked, boolean activeCooling, int maxParallelism, int coolant, int maxCoolant, int hotCoolant, int maxHotCoolant, int energyStored, long totalCrafted, Levels level, List<WorkerStatus> workers) {
        this.length = length;
        this.overclocked = overclocked;
        this.activeCooling = activeCooling;
        this.maxParallelism = maxParallelism;
        this.coolant = coolant;
        this.maxCoolant = maxCoolant;
        this.hotCoolant = hotCoolant;
        this.maxHotCoolant = maxHotCoolant;
        this.energyStored = energyStored;
        this.totalCrafted = totalCrafted;
        this.level = level;
        this.workers = workers;
    }

    public void write(ByteBuf buf) {
        buf.writeInt(this.length);
        buf.writeBoolean(this.overclocked);
        buf.writeBoolean(this.activeCooling);
        buf.writeInt(this.maxParallelism);
        buf.writeInt(this.coolant);
        buf.writeInt(this.maxCoolant);
        buf.writeInt(this.hotCoolant);
        buf.writeInt(this.maxHotCoolant);
        buf.writeInt(this.energyStored);
        buf.writeLong(this.totalCrafted);
        buf.writeByte(this.level.ordinal());
        this.workers.forEach(worker -> {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)((WorkerStatus)worker).crafting);
            buf.writeInt(((WorkerStatus)worker).queueLength);
        });
    }

    public static EFabricatorData read(ByteBuf buf) {
        int len = buf.readInt();
        boolean overclocked = buf.readBoolean();
        boolean activeCooling = buf.readBoolean();
        int maxParallelism = buf.readInt();
        int coolant = buf.readInt();
        int maxCoolant = buf.readInt();
        int hotCoolant = buf.readInt();
        int maxHotCoolant = buf.readInt();
        int energyStored = buf.readInt();
        long totalCrafted = buf.readLong();
        Levels level = Levels.values()[buf.readByte()];
        ArrayList<WorkerStatus> workers = new ArrayList<WorkerStatus>(len);
        IntStream.range(0, len).mapToObj(i -> ByteBufUtils.readItemStack((ByteBuf)buf)).forEach(crafting -> workers.add(new WorkerStatus((ItemStack)crafting, buf.readInt())));
        return new EFabricatorData(len, overclocked, activeCooling, maxParallelism, coolant, maxCoolant, hotCoolant, maxHotCoolant, energyStored, totalCrafted, level, workers);
    }

    public String toString() {
        return "EFabricatorData[" + "length=" + this.length + "," + "overclocked=" + this.overclocked + "," + "activeCooling=" + this.activeCooling + "," + "maxParallelism=" + this.maxParallelism + "," + "coolant=" + this.coolant + "," + "maxCoolant=" + this.maxCoolant + "," + "hotCoolant=" + this.hotCoolant + "," + "maxHotCoolant=" + this.maxHotCoolant + "," + "energyStored=" + this.energyStored + "," + "totalCrafted=" + this.totalCrafted + "," + "level=" + (Object)((Object)this.level) + "," + "workers=" + this.workers + "]";
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + this.length;
        result = 31 * result + (this.overclocked ? 1 : 0);
        result = 31 * result + (this.activeCooling ? 1 : 0);
        result = 31 * result + this.maxParallelism;
        result = 31 * result + this.coolant;
        result = 31 * result + this.maxCoolant;
        result = 31 * result + this.hotCoolant;
        result = 31 * result + this.maxHotCoolant;
        result = 31 * result + this.energyStored;
        result = 31 * result + (int)(this.totalCrafted ^ this.totalCrafted >>> 32);
        result = 31 * result + (this.level != null ? this.level.hashCode() : 0);
        result = 31 * result + (this.workers != null ? this.workers.hashCode() : 0);
        return result;
    }

    public final boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 == null) {
            return false;
        }
        if (arg0.getClass() != this.getClass()) {
            return false;
        }
        if (((EFabricatorData)arg0).length != this.length) {
            return false;
        }
        if (((EFabricatorData)arg0).overclocked != this.overclocked) {
            return false;
        }
        if (((EFabricatorData)arg0).activeCooling != this.activeCooling) {
            return false;
        }
        if (((EFabricatorData)arg0).maxParallelism != this.maxParallelism) {
            return false;
        }
        if (((EFabricatorData)arg0).coolant != this.coolant) {
            return false;
        }
        if (((EFabricatorData)arg0).maxCoolant != this.maxCoolant) {
            return false;
        }
        if (((EFabricatorData)arg0).hotCoolant != this.hotCoolant) {
            return false;
        }
        if (((EFabricatorData)arg0).maxHotCoolant != this.maxHotCoolant) {
            return false;
        }
        if (((EFabricatorData)arg0).energyStored != this.energyStored) {
            return false;
        }
        if (((EFabricatorData)arg0).totalCrafted != this.totalCrafted) {
            return false;
        }
        if (!Objects.equals((Object)((EFabricatorData)arg0).level, (Object)this.level)) {
            return false;
        }
        return Objects.equals(((EFabricatorData)arg0).workers, this.workers);
        {
        }
    }

    public int length() {
        return this.length;
    }

    public boolean overclocked() {
        return this.overclocked;
    }

    public boolean activeCooling() {
        return this.activeCooling;
    }

    public int maxParallelism() {
        return this.maxParallelism;
    }

    public int coolant() {
        return this.coolant;
    }

    public int maxCoolant() {
        return this.maxCoolant;
    }

    public int hotCoolant() {
        return this.hotCoolant;
    }

    public int maxHotCoolant() {
        return this.maxHotCoolant;
    }

    public int energyStored() {
        return this.energyStored;
    }

    public long totalCrafted() {
        return this.totalCrafted;
    }

    public Levels level() {
        return this.level;
    }

    public List<WorkerStatus> workers() {
        return this.workers;
    }

    public static final class WorkerStatus {
        private final ItemStack crafting;
        private final int queueLength;

        public WorkerStatus(ItemStack crafting, int queueLength) {
            this.crafting = crafting;
            this.queueLength = queueLength;
        }

        public String toString() {
            return "WorkerStatus[" + "crafting=" + this.crafting + "," + "queueLength=" + this.queueLength + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.crafting != null ? this.crafting.hashCode() : 0);
            result = 31 * result + this.queueLength;
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((WorkerStatus)arg0).crafting, this.crafting)) {
                return false;
            }
            return ((WorkerStatus)arg0).queueLength == this.queueLength;
            {
            }
        }

        public ItemStack crafting() {
            return this.crafting;
        }

        public int queueLength() {
            return this.queueLength;
        }
    }
}

