/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import github.kasuminova.novaeng.NovaEngineeringCore;
import github.kasuminova.novaeng.common.hypernet.old.research.SimpleResearchData;
import github.kasuminova.novaeng.common.registry.RegistryHyperNet;
import io.netty.util.internal.ThrowableUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.io.FileUtils;

public class ExportResearchDataToJson
extends CommandBase {
    public static final ExportResearchDataToJson INSTANCE = new ExportResearchDataToJson();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    private ExportResearchDataToJson() {
    }

    @Nonnull
    public String func_71517_b() {
        return "export_research_data_to_json";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "Usage: /export_research_data_to_json";
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) {
        List dataList = RegistryHyperNet.getAllResearchCognitionData().stream().map(SimpleResearchData::of).collect(Collectors.toList());
        String jsonString = GSON.toJson((Object)new ToSerialize(dataList));
        try {
            FileUtils.write((File)new File("./hypernet_research_data.json"), (CharSequence)jsonString, (Charset)StandardCharsets.UTF_8);
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Successfully export research data to hypernet_research_data.json!"));
        }
        catch (IOException e) {
            NovaEngineeringCore.log.warn(ThrowableUtil.stackTraceToString((Throwable)e));
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Failed to export research data!"));
        }
    }

    private static final class ToSerialize {
        private final List<SimpleResearchData> dataList;

        private ToSerialize(List<SimpleResearchData> dataList) {
            this.dataList = dataList;
        }

        public String toString() {
            return "ToSerialize[" + "dataList=" + this.dataList + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.dataList != null ? this.dataList.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            return Objects.equals(((ToSerialize)arg0).dataList, this.dataList);
            {
            }
        }

        public List<SimpleResearchData> dataList() {
            return this.dataList;
        }
    }
}

