/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.command;

import github.kasuminova.novaeng.client.handler.ClientEventHandler;
import github.kasuminova.novaeng.common.profiler.CPacketProfiler;
import github.kasuminova.novaeng.common.profiler.TEUpdatePacketProfiler;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class CommandPacketProfiler
extends CommandBase {
    public static final CommandPacketProfiler INSTANCE = new CommandPacketProfiler();

    private CommandPacketProfiler() {
    }

    @Nonnull
    public String func_71517_b() {
        return "packet_profiler";
    }

    @Nonnull
    public List<String> func_71514_a() {
        return Collections.emptyList();
    }

    @Nonnull
    public List<String> func_184883_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandPacketProfiler.func_71530_a((String[])args, (String[])new String[]{"reset", "start", "stop", "debug_limit", "te_debug_limit"});
        }
        return super.func_184883_a(server, sender, args, targetPos);
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "Usage: /packet_profiler [reset|start|stop|debug_limit <limit>|te_debug_limit <limit>]";
    }

    public boolean func_184882_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender) {
        return sender instanceof EntityPlayer;
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) {
        if (args.length == 0) {
            for (String message : CPacketProfiler.getProfilerMessages(10)) {
                sender.func_145747_a((ITextComponent)new TextComponentString(message));
            }
            for (String message : TEUpdatePacketProfiler.getProfilerMessages(10)) {
                sender.func_145747_a((ITextComponent)new TextComponentString(message));
            }
            return;
        }
        if (args.length >= 2) {
            try {
                switch (args[0]) {
                    case "debug_limit": {
                        ClientEventHandler.debugPacketProfilerMessageLimit = Integer.parseInt(args[1]);
                        break;
                    }
                    case "te_debug_limit": {
                        ClientEventHandler.debugTEPacketProfilerMessageLimit = Integer.parseInt(args[1]);
                    }
                }
            }
            catch (Exception e) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Invalid parameter " + args[1]));
            }
        }
        switch (args[0]) {
            case "reset": {
                CPacketProfiler.PACKET_TOTAL_SIZE.clear();
                CPacketProfiler.TOTAL_RECEIVED_DATA_SIZE.set(0L);
                CPacketProfiler.profilerStartTime = System.currentTimeMillis();
                TEUpdatePacketProfiler.TE_UPDATE_PACKET_TOTAL_SIZE.clear();
                sender.func_145747_a((ITextComponent)new TextComponentString("Cleared packet profiler data."));
                break;
            }
            case "start": {
                CPacketProfiler.enabled = true;
                CPacketProfiler.profilerStartTime += System.currentTimeMillis() - CPacketProfiler.profilerStopTime;
                sender.func_145747_a((ITextComponent)new TextComponentString("Packet profiler is started."));
                break;
            }
            case "stop": {
                CPacketProfiler.enabled = false;
                CPacketProfiler.profilerStopTime = System.currentTimeMillis();
                sender.func_145747_a((ITextComponent)new TextComponentString("Packet profiler is stopped."));
            }
        }
    }
}

