/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.block.ecotech.estorage;

import github.kasuminova.novaeng.common.block.ecotech.estorage.BlockEStoragePart;
import github.kasuminova.novaeng.common.block.ecotech.estorage.prop.EnergyCellStatus;
import github.kasuminova.novaeng.common.block.prop.FacingProp;
import github.kasuminova.novaeng.common.core.CreativeTabNovaEng;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageEnergyCell;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockEStorageEnergyCell
extends BlockEStoragePart {
    public static final BlockEStorageEnergyCell L4 = new BlockEStorageEnergyCell("l4", 1.0E7);
    public static final BlockEStorageEnergyCell L6 = new BlockEStorageEnergyCell("l6", 1.0E8);
    public static final BlockEStorageEnergyCell L9 = new BlockEStorageEnergyCell("l9", 1.0E9);
    protected final double maxEnergyStore;

    protected BlockEStorageEnergyCell(String level, double maxEnergyStore) {
        super(Material.field_151573_f);
        this.func_149711_c(20.0f);
        this.func_149752_b(2000.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149647_a(CreativeTabNovaEng.INSTANCE);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FacingProp.HORIZONTALS, (Comparable)EnumFacing.NORTH).func_177226_a(EnergyCellStatus.STATUS, (Comparable)((Object)EnergyCellStatus.EMPTY)));
        this.setRegistryName(new ResourceLocation("novaeng_core", "estorage_energy_cell_" + level));
        this.func_149663_c("novaeng_core.estorage_energy_cell_" + level);
        this.maxEnergyStore = maxEnergyStore;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new EStorageEnergyCell(this.maxEnergyStore);
    }

    @Nullable
    public TileEntity func_149915_a(@Nonnull World world, int meta) {
        return new EStorageEnergyCell(this.maxEnergyStore);
    }

    public int func_149750_m(@Nonnull IBlockState state) {
        return ((EnergyCellStatus)((Object)state.func_177229_b(EnergyCellStatus.STATUS))).ordinal() * 2;
    }

    public void func_180653_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, float chance, int fortune) {
    }

    public void func_180663_b(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        ItemStack dropped = new ItemStack(Item.func_150898_a((Block)this));
        if (dropped.func_190926_b()) {
            super.func_180653_a(world, pos, state, 1.0f, 0);
            world.func_175713_t(pos);
            return;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof EStorageEnergyCell)) {
            super.func_180653_a(world, pos, state, 1.0f, 0);
            world.func_175713_t(pos);
            return;
        }
        EStorageEnergyCell cell = (EStorageEnergyCell)tileEntity;
        NBTTagCompound tag = new NBTTagCompound();
        cell.writeCustomNBT(tag);
        cell.setEnergyStored(0.0);
        dropped.func_77982_d(tag);
        BlockEStorageEnergyCell.func_180635_a((World)world, (BlockPos)pos, (ItemStack)dropped);
        world.func_175713_t(pos);
    }

    @Nonnull
    public IBlockState func_180642_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(FacingProp.HORIZONTALS, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(FacingProp.HORIZONTALS)).func_176736_b();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FacingProp.HORIZONTALS, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof EStorageEnergyCell) {
            EStorageEnergyCell cell = (EStorageEnergyCell)tileEntity;
            return state.func_177226_a(EnergyCellStatus.STATUS, (Comparable)((Object)EStorageEnergyCell.getStatusFromFillFactor(cell.getFillFactor())));
        }
        return super.func_176221_a(state, world, pos);
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase placer, @Nonnull ItemStack stack) {
        TileEntity tileEntity;
        super.func_180633_a(world, pos, state, placer, stack);
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("energyStored") && tag.func_74764_b("maxEnergyStore") && (tileEntity = world.func_175625_s(pos)) instanceof EStorageEnergyCell) {
            EStorageEnergyCell cell = (EStorageEnergyCell)tileEntity;
            cell.readCustomNBT(tag);
        }
    }

    @Nonnull
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a(FacingProp.HORIZONTALS, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b(FacingProp.HORIZONTALS)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FacingProp.HORIZONTALS, EnergyCellStatus.STATUS});
    }
}

