/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.block.ecotech.estorage;

import appeng.api.AEApi;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.tile.inventory.AppEngCellInventory;
import github.kasuminova.novaeng.common.block.ecotech.estorage.BlockEStoragePart;
import github.kasuminova.novaeng.common.block.ecotech.estorage.prop.DriveStatus;
import github.kasuminova.novaeng.common.block.ecotech.estorage.prop.DriveStorageCapacity;
import github.kasuminova.novaeng.common.block.ecotech.estorage.prop.DriveStorageLevel;
import github.kasuminova.novaeng.common.block.ecotech.estorage.prop.DriveStorageType;
import github.kasuminova.novaeng.common.block.prop.FacingProp;
import github.kasuminova.novaeng.common.core.CreativeTabNovaEng;
import github.kasuminova.novaeng.common.estorage.EStorageCellHandler;
import github.kasuminova.novaeng.common.item.estorage.EStorageCell;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageCellDrive;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockEStorageCellDrive
extends BlockEStoragePart {
    public static final BlockEStorageCellDrive INSTANCE = new BlockEStorageCellDrive();

    protected BlockEStorageCellDrive() {
        super(Material.field_151573_f);
        this.func_149711_c(20.0f);
        this.func_149752_b(2000.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149647_a(CreativeTabNovaEng.INSTANCE);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FacingProp.HORIZONTALS, (Comparable)EnumFacing.NORTH).func_177226_a(DriveStorageType.STORAGE_TYPE, (Comparable)((Object)DriveStorageType.EMPTY)).func_177226_a(DriveStorageLevel.STORAGE_LEVEL, (Comparable)((Object)DriveStorageLevel.EMPTY)).func_177226_a(DriveStorageCapacity.STORAGE_CAPACITY, (Comparable)((Object)DriveStorageCapacity.EMPTY)).func_177226_a(DriveStatus.STATUS, (Comparable)((Object)DriveStatus.IDLE)));
        this.setRegistryName(new ResourceLocation("novaeng_core", "estorage_cell_drive"));
        this.func_149663_c("novaeng_core.estorage_cell_drive");
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new EStorageCellDrive();
    }

    @Nullable
    public TileEntity func_149915_a(@Nonnull World world, int meta) {
        return new EStorageCellDrive();
    }

    public void func_180663_b(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof EStorageCellDrive) {
            EStorageCellDrive drive = (EStorageCellDrive)te;
            AppEngCellInventory inv = drive.getDriveInv();
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                BlockEStorageCellDrive.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
                inv.setStackInSlot(i, ItemStack.field_190927_a);
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public int func_149750_m(@Nonnull IBlockState state) {
        return state.func_177229_b(DriveStorageType.STORAGE_TYPE) == DriveStorageType.EMPTY ? 1 : 5;
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        IStorageChannel channel;
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof EStorageCellDrive)) {
            return state;
        }
        EStorageCellDrive drive = (EStorageCellDrive)te;
        AppEngCellInventory driveInv = drive.getDriveInv();
        ItemStack stack = driveInv.getStackInSlot(0);
        if (stack.func_190926_b()) {
            return state;
        }
        EStorageCellHandler handler = EStorageCellHandler.getHandler(stack);
        if (handler == null) {
            return state;
        }
        EStorageCell cell = (EStorageCell)stack.func_77973_b();
        DriveStorageLevel level = cell.getLevel();
        DriveStorageType type = EStorageCellDrive.getCellType(cell);
        if (type == null) {
            return state;
        }
        Collection storageChannels = AEApi.instance().storage().storageChannels();
        ICellInventoryHandler cellInventory = null;
        Iterator iterator = storageChannels.iterator();
        while (iterator.hasNext() && (cellInventory = handler.getCellInventory(stack, drive, channel = (IStorageChannel)iterator.next())) == null) {
        }
        if (cellInventory == null) {
            return state;
        }
        return state.func_177226_a(DriveStorageLevel.STORAGE_LEVEL, (Comparable)((Object)level)).func_177226_a(DriveStorageType.STORAGE_TYPE, (Comparable)((Object)type)).func_177226_a(DriveStatus.STATUS, (Comparable)((Object)(drive.isWriting() ? DriveStatus.RUN : DriveStatus.IDLE))).func_177226_a(DriveStorageCapacity.STORAGE_CAPACITY, (Comparable)((Object)EStorageCellDrive.getCapacity(cellInventory)));
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FacingProp.HORIZONTALS, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return ((EnumFacing)state.func_177229_b(FacingProp.HORIZONTALS)).func_176736_b();
    }

    @Nonnull
    public IBlockState func_180642_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(FacingProp.HORIZONTALS, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    @Nonnull
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a(FacingProp.HORIZONTALS, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b(FacingProp.HORIZONTALS)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FacingProp.HORIZONTALS, DriveStorageType.STORAGE_TYPE, DriveStorageLevel.STORAGE_LEVEL, DriveStorageCapacity.STORAGE_CAPACITY, DriveStatus.STATUS});
    }
}

