/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.block.ecotech.efabricator;

import github.kasuminova.novaeng.common.CommonProxy;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorController;
import hellfirepvp.modularmachinery.common.block.BlockController;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import hellfirepvp.modularmachinery.common.util.IOInventory;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class BlockEFabricatorController
extends BlockController {
    public static final Map<ResourceLocation, BlockEFabricatorController> REGISTRY = new LinkedHashMap<ResourceLocation, BlockEFabricatorController>();
    public static final BlockEFabricatorController L4 = new BlockEFabricatorController("l4");
    public static final BlockEFabricatorController L6;
    public static final BlockEFabricatorController L9;
    protected final ResourceLocation registryName;
    protected final ResourceLocation machineRegistryName;

    public BlockEFabricatorController(String level) {
        this.func_149711_c(20.0f);
        this.func_149752_b(2000.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.field_149787_q = false;
        this.registryName = new ResourceLocation("novaeng_core", "extendable_fabricator_subsystem_" + level);
        this.machineRegistryName = new ResourceLocation("modularmachinery", this.registryName.func_110623_a());
        this.setRegistryName(this.registryName);
        this.func_149663_c("novaeng_core." + this.registryName.func_110623_a());
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return super.func_176221_a(state, worldIn, pos);
        }
        return state;
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
    }

    public void func_180663_b(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        Random rand = worldIn.field_73012_v;
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof EFabricatorController) {
            EFabricatorController ctrl = (EFabricatorController)te;
            IOInventory inv = ctrl.getInventory();
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                BlockEFabricatorController.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
                inv.setStackInSlot(i, ItemStack.field_190927_a);
            }
            UUID ownerUUID = ctrl.getOwner();
            Item dropped = this.func_180660_a(state, rand, this.func_180651_a(state));
            ItemStack stackCtrl = new ItemStack(dropped, 1);
            if (ownerUUID != null) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("owner", ownerUUID.toString());
                stackCtrl.func_77982_d(tag);
            }
            BlockEFabricatorController.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stackCtrl);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public int func_149750_m(@Nonnull IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)FORMED) != false ? 10 : 0;
    }

    public boolean func_180639_a(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) instanceof EFabricatorController) {
            playerIn.openGui((Object)"novaeng_core", CommonProxy.GuiType.EFABRICATOR_CONTROLLER.ordinal(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public DynamicMachine getParentMachine() {
        return MachineRegistry.getRegistry().getMachine(this.machineRegistryName);
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new EFabricatorController(this.machineRegistryName);
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new EFabricatorController(this.machineRegistryName);
    }

    static {
        REGISTRY.put(BlockEFabricatorController.L4.registryName, L4);
        L6 = new BlockEFabricatorController("l6");
        REGISTRY.put(BlockEFabricatorController.L6.registryName, L6);
        L9 = new BlockEFabricatorController("l9");
        REGISTRY.put(BlockEFabricatorController.L9.registryName, L9);
    }
}

