/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.adapter.util;

import cofh.thermalexpansion.util.managers.machine.PulverizerManager;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementEnergy;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementItem;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementType;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;

public class PulverizerRecipeConverter {
    public static List<MachineRecipe> convert(Function<ItemStack, MachineRecipe> recipeSupplier, Predicate<List<ItemStack>> inputFilter, List<RecipeModifier> modifiers) {
        PulverizerManager.PulverizerRecipe[] recipeList = PulverizerManager.getRecipeList();
        LinkedList<MachineRecipe> machineRecipes = new LinkedList<MachineRecipe>();
        for (PulverizerManager.PulverizerRecipe recipe : recipeList) {
            int secondOutAmount;
            int outAmount;
            int energy = recipe.getEnergy();
            ItemStack input = recipe.getInput();
            ItemStack primaryOutput = recipe.getPrimaryOutput();
            ItemStack secondaryOutput = recipe.getSecondaryOutput();
            int secondaryOutputChance = recipe.getSecondaryOutputChance();
            if (!inputFilter.test(Collections.singletonList(input))) continue;
            MachineRecipe machineRecipe = recipeSupplier.apply(input);
            machineRecipe.addRequirement((ComponentRequirement)new RequirementEnergy(IOType.INPUT, (long)Math.round(RecipeModifier.applyModifiers(modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_ENERGY, (IOType)IOType.INPUT, (float)((float)energy / 200.0f), (boolean)false))));
            int inAmount = Math.round(RecipeModifier.applyModifiers(modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_ITEM, (IOType)IOType.INPUT, (float)input.func_190916_E(), (boolean)false));
            if (inAmount >= 1) {
                machineRecipe.addRequirement((ComponentRequirement)new RequirementItem(IOType.INPUT, ItemUtils.copyStackWithSize((ItemStack)input, (int)inAmount)));
            }
            if ((outAmount = Math.round(RecipeModifier.applyModifiers(modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_ITEM, (IOType)IOType.OUTPUT, (float)primaryOutput.func_190916_E(), (boolean)false))) >= 1) {
                machineRecipe.addRequirement((ComponentRequirement)new RequirementItem(IOType.OUTPUT, ItemUtils.copyStackWithSize((ItemStack)primaryOutput, (int)outAmount)));
            }
            if ((secondOutAmount = Math.round(RecipeModifier.applyModifiers(modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_ITEM, (IOType)IOType.OUTPUT, (float)secondaryOutput.func_190916_E(), (boolean)false))) >= 1) {
                float chance = RecipeModifier.applyModifiers(modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_ITEM, (IOType)IOType.OUTPUT, (float)((float)secondaryOutputChance / 100.0f), (boolean)true);
                RequirementItem req = new RequirementItem(IOType.OUTPUT, ItemUtils.copyStackWithSize((ItemStack)secondaryOutput, (int)secondOutAmount));
                req.setChance(chance);
                machineRecipe.addRequirement((ComponentRequirement)req);
            }
            machineRecipes.add(machineRecipe);
        }
        return machineRecipes;
    }
}

