/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.adapter.util;

import github.kasuminova.mmce.common.itemtype.ChancedIngredientStack;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementEnergy;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementFluid;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementIngredientArray;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementItem;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementType;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import nc.recipe.BasicRecipe;
import nc.recipe.NCRecipes;
import nc.recipe.ingredient.ChanceItemIngredient;
import nc.recipe.ingredient.EmptyItemIngredient;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;
import nc.recipe.ingredient.ItemArrayIngredient;
import nc.recipe.ingredient.OreIngredient;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class NCOBasicRecipeConverter {
    protected static void addItemIngredient(List<RecipeModifier> modifiers, IItemIngredient ingredient, MachineRecipe recipe, ItemStack stack, IOType ioType) {
        int inAmount = Math.round(RecipeModifier.applyModifiers(modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_ITEM, (IOType)IOType.INPUT, (float)stack.func_190916_E(), (boolean)false));
        if (ingredient instanceof OreIngredient) {
            OreIngredient oreIngredient = (OreIngredient)ingredient;
            recipe.addRequirement((ComponentRequirement)new RequirementItem(ioType, oreIngredient.oreName, inAmount));
            return;
        }
        if (ingredient instanceof ItemArrayIngredient) {
            ItemArrayIngredient arrayIngredient = (ItemArrayIngredient)ingredient;
            List ingredientList = arrayIngredient.ingredientList;
            ArrayList<ChancedIngredientStack> ingredientStackList = new ArrayList<ChancedIngredientStack>(ingredientList.size());
            for (IItemIngredient itemIngredient : ingredientList) {
                if (itemIngredient instanceof OreIngredient) {
                    OreIngredient oreIngredient = (OreIngredient)itemIngredient;
                    int subInAmount = Math.round(RecipeModifier.applyModifiers(modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_ITEM, (IOType)ioType, (float)oreIngredient.stackSize, (boolean)false));
                    ingredientStackList.add(new ChancedIngredientStack(oreIngredient.oreName, subInAmount));
                    continue;
                }
                ItemStack ingredientStack = (ItemStack)itemIngredient.getStack();
                int subInAmount = Math.round(RecipeModifier.applyModifiers(modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_ITEM, (IOType)ioType, (float)ingredientStack.func_190916_E(), (boolean)false));
                ingredientStackList.add(new ChancedIngredientStack(ItemUtils.copyStackWithSize((ItemStack)ingredientStack, (int)subInAmount)));
            }
            recipe.addRequirement((ComponentRequirement)new RequirementIngredientArray(ingredientStackList));
            return;
        }
        RequirementItem req = new RequirementItem(ioType, ItemUtils.copyStackWithSize((ItemStack)stack, (int)inAmount));
        if (ingredient instanceof ChanceItemIngredient) {
            ChanceItemIngredient chanceItemIngredient = (ChanceItemIngredient)ingredient;
            float chance = RecipeModifier.applyModifiers(modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_ITEM, (IOType)IOType.OUTPUT, (float)((float)chanceItemIngredient.getChancePercent() / 100.0f), (boolean)true);
            req.setChance(chance);
        }
        recipe.addRequirement((ComponentRequirement)req);
    }

    protected static void addFluidIngredient(List<RecipeModifier> modifiers, IFluidIngredient fluidIngredient, MachineRecipe recipe, IOType ioType) {
        FluidStack fluidStack = (FluidStack)fluidIngredient.getStack();
        if (fluidStack == null) {
            return;
        }
        FluidStack copied = fluidStack.copy();
        int outputAmount = Math.round(RecipeModifier.applyModifiers(modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_FLUID, (IOType)ioType, (float)copied.amount, (boolean)false));
        if (outputAmount > 0) {
            copied.amount = outputAmount;
            recipe.addRequirement((ComponentRequirement)new RequirementFluid(ioType, copied));
        }
    }

    public static List<MachineRecipe> convert(Function<ItemStack, MachineRecipe> recipeSupplier, Predicate<List<ItemStack>> inputFilter, List<RecipeModifier> modifiers, int baseEnergyUsage) {
        List recipeList = NCRecipes.manufactory.getRecipeList();
        LinkedList<MachineRecipe> machineRecipes = new LinkedList<MachineRecipe>();
        for (BasicRecipe basicRecipe : recipeList) {
            LinkedList inputList = basicRecipe.getItemIngredients().stream().flatMap(ingredient -> ingredient.getInputStackHashingList().stream()).collect(Collectors.toCollection(LinkedList::new));
            if (inputList.isEmpty() || !inputFilter.test(inputList)) continue;
            MachineRecipe recipe = recipeSupplier.apply((ItemStack)inputList.get(0));
            basicRecipe.getItemIngredients().stream().filter(ingredient -> !(ingredient instanceof EmptyItemIngredient)).forEach(ingredient -> NCOBasicRecipeConverter.addItemIngredient(modifiers, ingredient, recipe, (ItemStack)ingredient.getStack(), IOType.INPUT));
            basicRecipe.getItemProducts().stream().filter(itemProduct -> !(itemProduct instanceof EmptyItemIngredient)).forEach(itemProduct -> NCOBasicRecipeConverter.addItemIngredient(modifiers, itemProduct, recipe, (ItemStack)itemProduct.getStack(), IOType.OUTPUT));
            basicRecipe.getFluidIngredients().forEach(fluidIngredient -> NCOBasicRecipeConverter.addFluidIngredient(modifiers, fluidIngredient, recipe, IOType.INPUT));
            basicRecipe.getFluidProducts().forEach(fluidProduct -> NCOBasicRecipeConverter.addFluidIngredient(modifiers, fluidProduct, recipe, IOType.OUTPUT));
            recipe.addRequirement((ComponentRequirement)new RequirementEnergy(IOType.INPUT, (long)Math.round(RecipeModifier.applyModifiers(modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_ENERGY, (IOType)IOType.INPUT, (float)baseEnergyUsage, (boolean)false))));
            machineRecipes.add(recipe);
        }
        return machineRecipes;
    }
}

