/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.adapter.util;

import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementEnergy;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementItem;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementType;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.outputs.ItemStackOutput;
import net.minecraft.item.ItemStack;

public class MekCrusherRecipeConverter {
    public static List<MachineRecipe> convert(Function<ItemStack, MachineRecipe> recipeSupplier, Predicate<List<ItemStack>> inputFilter, List<RecipeModifier> modifiers, int baseEnergyUsage) {
        Object2ObjectOpenHashMap crusherRecipes = RecipeHandler.Recipe.CRUSHER.get();
        LinkedList<MachineRecipe> machineRecipes = new LinkedList<MachineRecipe>();
        crusherRecipes.forEach((input, mekRecipe) -> {
            int inEnergy;
            int outAmount;
            ItemStack inputStack = input.ingredient;
            ItemStack outputStack = ((ItemStackOutput)mekRecipe.getOutput()).output;
            if (!inputFilter.test(Collections.singletonList(inputStack))) {
                return;
            }
            MachineRecipe recipe = (MachineRecipe)recipeSupplier.apply(inputStack);
            int inAmount = Math.round(RecipeModifier.applyModifiers((Collection)modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_ITEM, (IOType)IOType.INPUT, (float)inputStack.func_190916_E(), (boolean)false));
            if (inAmount > 0) {
                recipe.addRequirement((ComponentRequirement)new RequirementItem(IOType.INPUT, ItemUtils.copyStackWithSize((ItemStack)inputStack, (int)inAmount)));
            }
            if ((outAmount = Math.round(RecipeModifier.applyModifiers((Collection)modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_ITEM, (IOType)IOType.OUTPUT, (float)outputStack.func_190916_E(), (boolean)false))) > 0) {
                recipe.addRequirement((ComponentRequirement)new RequirementItem(IOType.OUTPUT, ItemUtils.copyStackWithSize((ItemStack)outputStack, (int)outAmount)));
            }
            if ((inEnergy = Math.round(RecipeModifier.applyModifiers((Collection)modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_ENERGY, (IOType)IOType.INPUT, (float)baseEnergyUsage, (boolean)false))) > 0) {
                recipe.addRequirement((ComponentRequirement)new RequirementEnergy(IOType.INPUT, (long)inEnergy));
            }
            machineRecipes.add(recipe);
        });
        return machineRecipes;
    }
}

