/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.adapter.util;

import github.kasuminova.mmce.common.itemtype.ChancedIngredientStack;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementEnergy;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementIngredientArray;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementItem;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementType;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.Recipes;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;

public class IC2MachineRecipeConverter {
    public static List<MachineRecipe> convertMaceratorRecipes(Function<ItemStack, MachineRecipe> recipeSupplier, Predicate<List<ItemStack>> inputFilter, List<RecipeModifier> modifiers, int baseEnergyUsage) {
        return IC2MachineRecipeConverter.convert(recipeSupplier, inputFilter, modifiers, baseEnergyUsage, Recipes.macerator.getRecipes());
    }

    public static List<MachineRecipe> convert(Function<ItemStack, MachineRecipe> recipeSupplier, Predicate<List<ItemStack>> inputFilter, List<RecipeModifier> modifiers, int baseEnergyUsage, Iterable<? extends ic2.api.recipe.MachineRecipe<IRecipeInput, Collection<ItemStack>>> icRecipes) {
        LinkedList<MachineRecipe> machineRecipes = new LinkedList<MachineRecipe>();
        for (ic2.api.recipe.MachineRecipe<IRecipeInput, Collection<ItemStack>> machineRecipe : icRecipes) {
            List inputs = ((IRecipeInput)machineRecipe.getInput()).getInputs();
            if (inputs.isEmpty() || !inputFilter.test(inputs)) continue;
            MachineRecipe recipe = recipeSupplier.apply((ItemStack)inputs.get(0));
            if (inputs.size() == 1) {
                int inAmount = Math.round(RecipeModifier.applyModifiers(modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_ITEM, (IOType)IOType.INPUT, (float)((IRecipeInput)machineRecipe.getInput()).getAmount(), (boolean)false));
                if (inAmount > 0) {
                    recipe.addRequirement((ComponentRequirement)new RequirementItem(IOType.INPUT, ItemUtils.copyStackWithSize((ItemStack)((ItemStack)inputs.get(0)), (int)inAmount)));
                }
            } else {
                LinkedList<ChancedIngredientStack> ingredientStackList = new LinkedList<ChancedIngredientStack>();
                for (ItemStack input : inputs) {
                    int inAmount = Math.round(RecipeModifier.applyModifiers(modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_ITEM, (IOType)IOType.INPUT, (float)((IRecipeInput)machineRecipe.getInput()).getAmount(), (boolean)false));
                    if (inAmount <= 0) continue;
                    ingredientStackList.add(new ChancedIngredientStack(input, (float)inAmount));
                }
                recipe.addRequirement((ComponentRequirement)new RequirementIngredientArray(ingredientStackList));
            }
            for (ItemStack output : (Collection)machineRecipe.getOutput()) {
                int outAmount = Math.round(RecipeModifier.applyModifiers(modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_ITEM, (IOType)IOType.OUTPUT, (float)output.func_190916_E(), (boolean)false));
                if (outAmount <= 0) continue;
                recipe.addRequirement((ComponentRequirement)new RequirementItem(IOType.OUTPUT, ItemUtils.copyStackWithSize((ItemStack)output, (int)outAmount)));
            }
            int inEnergy = Math.round(RecipeModifier.applyModifiers(modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_ENERGY, (IOType)IOType.INPUT, (float)baseEnergyUsage, (boolean)false));
            if (inEnergy > 0) {
                recipe.addRequirement((ComponentRequirement)new RequirementEnergy(IOType.INPUT, (long)inEnergy));
            }
            machineRecipes.add(recipe);
        }
        return machineRecipes;
    }
}

