/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.adapter.botania;

import com.meteor.extrabotany.api.ExtraBotanyAPI;
import crafttweaker.util.IEventHandler;
import github.kasuminova.mmce.common.event.Phase;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeFinishEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeTickEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeCheckEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeEvent;
import github.kasuminova.novaeng.common.machine.IllumPool;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.adapter.RecipeAdapter;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementItem;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementType;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipeManaInfusion;

public class AdapterBotaniaManaPool
extends RecipeAdapter {
    public AdapterBotaniaManaPool() {
        super(new ResourceLocation("botania", "pool"));
    }

    @Nonnull
    public Collection<MachineRecipe> createRecipesFor(ResourceLocation owningMachineName, List<RecipeModifier> modifiers, List<ComponentRequirement<?, ?>> additionalRequirements, Map<Class<?>, List<IEventHandler<RecipeEvent>>> eventHandlers, List<String> recipeTooltips) {
        if (!owningMachineName.equals((Object)IllumPool.REGISTRY_NAME)) {
            throw new IllegalArgumentException("AdapterBotaniaManaPool only can be used with IllumPool.");
        }
        ArrayList<MachineRecipe> recipes = new ArrayList<MachineRecipe>();
        for (RecipeManaInfusion infusionRecipe : BotaniaAPI.manaInfusionRecipes) {
            ItemStack output;
            int outAmount;
            MachineRecipe recipe = this.createRecipeShell(new ResourceLocation("botania", "mana_infusion_" + this.incId), owningMachineName, 20, 0, false);
            int inAmount = Math.round(RecipeModifier.applyModifiers(modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_ITEM, (IOType)IOType.INPUT, (float)1.0f, (boolean)false));
            if (inAmount >= 1) {
                Object input = infusionRecipe.getInput();
                if (input instanceof String) {
                    String oreDict = (String)input;
                    recipe.addRequirement((ComponentRequirement)new RequirementItem(IOType.INPUT, oreDict, inAmount));
                } else {
                    recipe.addRequirement((ComponentRequirement)new RequirementItem(IOType.INPUT, ItemUtils.copyStackWithSize((ItemStack)((ItemStack)input), (int)inAmount)));
                }
            }
            if ((outAmount = Math.round(RecipeModifier.applyModifiers(modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_ITEM, (IOType)IOType.OUTPUT, (float)(output = infusionRecipe.getOutput()).func_190916_E(), (boolean)false))) >= 1) {
                recipe.addRequirement((ComponentRequirement)new RequirementItem(IOType.OUTPUT, ItemUtils.copyStackWithSize((ItemStack)output, (int)outAmount)));
            }
            int manaToConsume = infusionRecipe.getManaToConsume();
            recipe.addRecipeEventHandler(RecipeCheckEvent.class, event -> {
                if (event.phase != Phase.START) {
                    return;
                }
                IllumPool.onRecipeCheck(event, manaToConsume);
            });
            recipe.addRecipeEventHandler(FactoryRecipeFinishEvent.class, IllumPool::onRecipeFinished);
            recipe.addRecipeEventHandler(FactoryRecipeTickEvent.class, event -> {
                if (event.phase != Phase.START) {
                    return;
                }
                IllumPool.onRecipeTick(event, manaToConsume);
            });
            recipe.addTooltip("\u9b54\u529b\u6d88\u8017\uff1a\u00a7b" + manaToConsume);
            IBlockState catalyst = infusionRecipe.getCatalyst();
            if (catalyst == null) {
                AdapterBotaniaManaPool.addDefaultCatalystHandler(recipe);
                recipe.addTooltip("\u8f89\u5149\u9b54\u529b\u6c60\u6a21\u5f0f\uff1a\u00a7a\u666e\u901a");
            } else if (catalyst.equals(RecipeManaInfusion.conjurationState)) {
                recipe.addRecipeEventHandler(RecipeCheckEvent.class, event -> {
                    if (event.phase != Phase.START) {
                        return;
                    }
                    TileMultiblockMachineController controller = event.getController();
                    if (!controller.hasModifierReplacement("conjurationCatalyst")) {
                        event.setFailed("\u8f89\u5149\u9b54\u529b\u6c60\u6a21\u5f0f\u4e0d\u5339\u914d\u6216\u7f3a\u5c11\u7269\u54c1\u8f93\u5165\uff01");
                    }
                });
                recipe.addTooltip("\u8f89\u5149\u9b54\u529b\u6c60\u6a21\u5f0f\uff1a\u00a7d\u70bc\u9020");
            } else if (catalyst.equals(RecipeManaInfusion.alchemyState)) {
                recipe.addRecipeEventHandler(RecipeCheckEvent.class, event -> {
                    if (event.phase != Phase.START) {
                        return;
                    }
                    TileMultiblockMachineController controller = event.getController();
                    if (!controller.hasModifierReplacement("alchemyCatalyst")) {
                        event.setFailed("\u8f89\u5149\u9b54\u529b\u6c60\u6a21\u5f0f\u4e0d\u5339\u914d\u6216\u7f3a\u5c11\u7269\u54c1\u8f93\u5165\uff01");
                    }
                });
                recipe.addTooltip("\u8f89\u5149\u9b54\u529b\u6c60\u6a21\u5f0f\uff1a\u00a7e\u70bc\u91d1");
            } else if (catalyst.equals(ExtraBotanyAPI.dimensionState)) {
                recipe.addRecipeEventHandler(RecipeCheckEvent.class, event -> {
                    if (event.phase != Phase.START) {
                        return;
                    }
                    TileMultiblockMachineController controller = event.getController();
                    if (!controller.hasModifierReplacement("dimensionCatalyst")) {
                        event.setFailed("\u8f89\u5149\u9b54\u529b\u6c60\u6a21\u5f0f\u4e0d\u5339\u914d\u6216\u7f3a\u5c11\u7269\u54c1\u8f93\u5165\uff01");
                    }
                });
                recipe.addTooltip("\u8f89\u5149\u9b54\u529b\u6c60\u6a21\u5f0f\uff1a\u00a75\u6b21\u5143");
            } else {
                AdapterBotaniaManaPool.addDefaultCatalystHandler(recipe);
            }
            recipe.addTooltip("\u6d88\u8017 \u00a7a1\u00a7f \u70b9\u00a7e\u8f89\u5149\u9b54\u529b\u00a7f\u53ef\u66ff\u4ee3 \u00a7a25%\u00a7f \u7684\u00a7b\u9b54\u529b\u6d88\u8017\u00a7f\u3002");
            recipes.add(recipe);
            ++this.incId;
        }
        return recipes;
    }

    protected static void addDefaultCatalystHandler(MachineRecipe recipe) {
        recipe.addRecipeEventHandler(RecipeCheckEvent.class, event -> {
            if (event.phase != Phase.START) {
                return;
            }
            TileMultiblockMachineController controller = event.getController();
            boolean hasCatalyst = false;
            if (controller.hasModifierReplacement("alchemyCatalyst")) {
                hasCatalyst = true;
            } else if (controller.hasModifierReplacement("conjurationCatalyst")) {
                hasCatalyst = true;
            } else if (controller.hasModifierReplacement("dimensionCatalyst")) {
                hasCatalyst = true;
            }
            if (hasCatalyst) {
                event.setFailed("\u8f89\u5149\u9b54\u529b\u6c60\u6a21\u5f0f\u4e0d\u5339\u914d\u6216\u7f3a\u5c11\u7269\u54c1\u8f93\u5165\uff01");
                return;
            }
            if (!controller.hasModifierReplacement("normal")) {
                event.setFailed("\u8f89\u5149\u9b54\u529b\u6c60\u6a21\u5f0f\u4e0d\u5339\u914d\u6216\u7f3a\u5c11\u7269\u54c1\u8f93\u5165\uff01");
            }
        });
    }
}

