/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.adapter.astralsorcery;

import crafttweaker.util.IEventHandler;
import github.kasuminova.mmce.common.event.Phase;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeFinishEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeTickEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeCheckEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeEvent;
import github.kasuminova.novaeng.common.machine.IllumPool;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.infusion.AbstractInfusionRecipe;
import hellfirepvp.astralsorcery.common.crafting.infusion.InfusionRecipeRegistry;
import hellfirepvp.astralsorcery.common.crafting.infusion.recipes.InfusionRecipeChargeTool;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.adapter.RecipeAdapter;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementFluid;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementItem;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementType;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class AdapterStarlightInfuser
extends RecipeAdapter {
    public AdapterStarlightInfuser() {
        super(new ResourceLocation("astralsorcery", "starlight_infuser"));
    }

    @Nonnull
    public Collection<MachineRecipe> createRecipesFor(ResourceLocation owningMachineName, List<RecipeModifier> modifiers, List<ComponentRequirement<?, ?>> additionalRequirements, Map<Class<?>, List<IEventHandler<RecipeEvent>>> eventHandlers, List<String> recipeTooltips) {
        if (!owningMachineName.equals((Object)IllumPool.REGISTRY_NAME)) {
            throw new IllegalArgumentException("AdapterStarlightInfuser only can be used with IllumPool.");
        }
        int ids = InfusionRecipeRegistry.recipes.size() + InfusionRecipeRegistry.mtRecipes.size();
        ArrayList<MachineRecipe> recipes = new ArrayList<MachineRecipe>();
        for (int id = 0; id < ids; ++id) {
            AbstractInfusionRecipe infusionRecipe = InfusionRecipeRegistry.getRecipe((int)id);
            if (infusionRecipe == null || infusionRecipe instanceof InfusionRecipeChargeTool) continue;
            MachineRecipe recipe = this.createRecipeShell(new ResourceLocation("astralsorcery", "infusion_" + this.incId), owningMachineName, 20, 0, false);
            ItemHandle input = infusionRecipe.getInput();
            switch (input.handleType) {
                case STACK: {
                    for (ItemStack applicableItem : input.getApplicableItems()) {
                        int inAmount = Math.round(RecipeModifier.applyModifiers(modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_ITEM, (IOType)IOType.INPUT, (float)applicableItem.func_190916_E(), (boolean)false));
                        if (inAmount <= 0) continue;
                        recipe.addRequirement((ComponentRequirement)new RequirementItem(IOType.INPUT, ItemUtils.copyStackWithSize((ItemStack)applicableItem, (int)inAmount)));
                    }
                    break;
                }
                case OREDICT: {
                    String oreDictName = input.getOreDictName();
                    int inAmount = Math.round(RecipeModifier.applyModifiers(modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_ITEM, (IOType)IOType.INPUT, (float)1.0f, (boolean)false));
                    if (inAmount <= 0) break;
                    recipe.addRequirement((ComponentRequirement)new RequirementItem(IOType.INPUT, oreDictName, inAmount));
                    break;
                }
                case FLUID: {
                    FluidStack fluidStack = input.getFluidTypeAndAmount();
                    assert (fluidStack != null);
                    int inAmount = Math.round(RecipeModifier.applyModifiers(modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_FLUID, (IOType)IOType.INPUT, (float)fluidStack.amount, (boolean)false));
                    if (inAmount <= 0) break;
                    FluidStack copied = fluidStack.copy();
                    copied.amount = inAmount;
                    recipe.addRequirement((ComponentRequirement)new RequirementFluid(IOType.INPUT, copied));
                }
            }
            ItemStack output = infusionRecipe.getOutput(null);
            int outAmount = Math.round(RecipeModifier.applyModifiers(modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_ITEM, (IOType)IOType.OUTPUT, (float)output.func_190916_E(), (boolean)false));
            if (outAmount > 0) {
                recipe.addRequirement((ComponentRequirement)new RequirementItem(IOType.OUTPUT, ItemUtils.copyStackWithSize((ItemStack)output, (int)outAmount)));
            }
            float consumeChance = infusionRecipe.getLiquidStarlightConsumptionChance();
            int craftingTickTime = infusionRecipe.craftingTickTime();
            int manaToConsume = Math.round((float)(craftingTickTime * 100) * consumeChance);
            recipe.addRecipeEventHandler(RecipeCheckEvent.class, event -> {
                if (event.phase != Phase.START) {
                    return;
                }
                IllumPool.onRecipeCheck(event, manaToConsume);
            });
            recipe.addRecipeEventHandler(FactoryRecipeFinishEvent.class, IllumPool::onRecipeFinished);
            recipe.addRecipeEventHandler(FactoryRecipeTickEvent.class, event -> {
                if (event.phase != Phase.START) {
                    return;
                }
                IllumPool.onRecipeTick(event, manaToConsume);
            });
            recipe.addTooltip("\u9b54\u529b\u6d88\u8017\uff1a\u00a7b" + manaToConsume);
            AdapterStarlightInfuser.addStarlightCatalystHandler(recipe);
            recipe.addTooltip("\u8f89\u5149\u9b54\u529b\u6c60\u6a21\u5f0f\uff1a\u00a7b\u661f\u5149");
            recipe.addTooltip("\u6d88\u8017 \u00a7a1\u00a7f \u70b9\u00a7e\u8f89\u5149\u9b54\u529b\u00a7f\u53ef\u66ff\u4ee3 \u00a7a25%\u00a7f \u7684\u00a7b\u9b54\u529b\u6d88\u8017\u00a7f\u3002");
            recipes.add(recipe);
            ++this.incId;
        }
        return recipes;
    }

    protected static void addStarlightCatalystHandler(MachineRecipe recipe) {
        recipe.addRecipeEventHandler(RecipeCheckEvent.class, event -> {
            if (event.phase != Phase.START) {
                return;
            }
            TileMultiblockMachineController controller = event.getController();
            boolean hasCatalyst = false;
            if (controller.hasModifierReplacement("alchemyCatalyst")) {
                hasCatalyst = true;
            } else if (controller.hasModifierReplacement("conjurationCatalyst")) {
                hasCatalyst = true;
            } else if (controller.hasModifierReplacement("dimensionCatalyst")) {
                hasCatalyst = true;
            }
            if (hasCatalyst) {
                event.setFailed("\u8f89\u5149\u9b54\u529b\u6c60\u6a21\u5f0f\u4e0d\u5339\u914d\u6216\u7f3a\u5c11\u7269\u54c1\u8f93\u5165\uff01");
                return;
            }
            if (!controller.hasModifierReplacement("starlightCatalyst")) {
                event.setFailed("\u8f89\u5149\u9b54\u529b\u6c60\u6a21\u5f0f\u4e0d\u5339\u914d\u6216\u7f3a\u5c11\u7269\u54c1\u8f93\u5165\uff01");
            }
        });
    }
}

