/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.adapter;

import crafttweaker.util.IEventHandler;
import github.kasuminova.mmce.common.event.recipe.RecipeEvent;
import github.kasuminova.novaeng.common.adapter.util.HashedItemStack;
import github.kasuminova.novaeng.common.adapter.util.IC2MachineRecipeConverter;
import github.kasuminova.novaeng.common.adapter.util.MekCrusherRecipeConverter;
import github.kasuminova.novaeng.common.adapter.util.NCOBasicRecipeConverter;
import github.kasuminova.novaeng.common.adapter.util.PulverizerRecipeConverter;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.adapter.RecipeAdapter;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementType;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class AdapterShredder
extends RecipeAdapter {
    protected int sortId = 0;

    public AdapterShredder() {
        super(new ResourceLocation("novaeng_core", "shredder"));
    }

    @Nonnull
    public Collection<MachineRecipe> createRecipesFor(ResourceLocation owningMachineName, List<RecipeModifier> modifiers, List<ComponentRequirement<?, ?>> additionalRequirements, Map<Class<?>, List<IEventHandler<RecipeEvent>>> eventHandlers, List<String> recipeTooltips) {
        HashSet registeredStack = new HashSet();
        LinkedList<MachineRecipe> recipes = new LinkedList<MachineRecipe>();
        recipes.addAll(PulverizerRecipeConverter.convert(stack -> this.createRecipeShell(owningMachineName, HashedItemStack.stackToString(stack), modifiers), stacks -> this.checkStackRegistered(registeredStack, (List<ItemStack>)stacks), modifiers));
        recipes.addAll(NCOBasicRecipeConverter.convert(stack -> this.createRecipeShell(owningMachineName, HashedItemStack.stackToString(stack), modifiers), stacks -> this.checkStackRegistered(registeredStack, (List<ItemStack>)stacks), modifiers, 10));
        recipes.addAll(MekCrusherRecipeConverter.convert(stack -> this.createRecipeShell(owningMachineName, HashedItemStack.stackToString(stack), modifiers), stacks -> this.checkStackRegistered(registeredStack, (List<ItemStack>)stacks), modifiers, 10));
        recipes.addAll(IC2MachineRecipeConverter.convertMaceratorRecipes(stack -> this.createRecipeShell(owningMachineName, HashedItemStack.stackToString(stack), modifiers), stacks -> this.checkStackRegistered(registeredStack, (List<ItemStack>)stacks), modifiers, 10));
        ++this.incId;
        return recipes;
    }

    protected MachineRecipe createRecipeShell(ResourceLocation owningMachineName, String suffix, List<RecipeModifier> modifiers) {
        MachineRecipe machineRecipe = this.createRecipeShell(new ResourceLocation("novaeng_core", "shredder_" + suffix + "_" + this.incId), owningMachineName, Math.round(RecipeModifier.applyModifiers(modifiers, (RequirementType)RequirementTypesMM.REQUIREMENT_DURATION, (IOType)IOType.INPUT, (float)200.0f, (boolean)false)), this.sortId, false);
        ++this.sortId;
        return machineRecipe;
    }

    protected boolean checkStackRegistered(Set<HashedItemStack> registeredStack, List<ItemStack> stacks) {
        ArrayList<HashedItemStack> checked = new ArrayList<HashedItemStack>();
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) {
                return false;
            }
            HashedItemStack hashedStack = HashedItemStack.ofTagUnsafe(stack);
            if (registeredStack.contains(hashedStack)) {
                return false;
            }
            checked.add(hashedStack.copy());
        }
        registeredStack.addAll(checked);
        return true;
    }

    public void resetIncId() {
        super.resetIncId();
        this.sortId = 0;
    }
}

