/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common;

import appeng.api.AEApi;
import appeng.api.storage.ICellHandler;
import appeng.api.storage.ITerminalHost;
import appeng.container.implementations.ContainerCraftConfirm;
import appeng.me.helpers.AENetworkProxy;
import github.kasuminova.mmce.common.integration.ModIntegrationAE2;
import github.kasuminova.novaeng.common.adapter.RecipeAdapterExtended;
import github.kasuminova.novaeng.common.container.ContainerEFabricatorController;
import github.kasuminova.novaeng.common.container.ContainerEFabricatorPatternBus;
import github.kasuminova.novaeng.common.container.ContainerEStorageController;
import github.kasuminova.novaeng.common.container.ContainerGeocentricDrill;
import github.kasuminova.novaeng.common.container.ContainerHyperNetTerminal;
import github.kasuminova.novaeng.common.container.ContainerModularServerAssembler;
import github.kasuminova.novaeng.common.container.ContainerSingularityCore;
import github.kasuminova.novaeng.common.container.appeng.ContainerCraftingTree;
import github.kasuminova.novaeng.common.estorage.EStorageCellHandler;
import github.kasuminova.novaeng.common.handler.EFabricatorEventHandler;
import github.kasuminova.novaeng.common.handler.EStorageEventHandler;
import github.kasuminova.novaeng.common.handler.HyperNetEventHandler;
import github.kasuminova.novaeng.common.handler.HyperNetMachineEventHandler;
import github.kasuminova.novaeng.common.hypernet.old.HyperNetTerminal;
import github.kasuminova.novaeng.common.hypernet.old.machine.AssemblyLine;
import github.kasuminova.novaeng.common.hypernet.old.recipe.HyperNetRecipeManager;
import github.kasuminova.novaeng.common.integration.IntegrationCRT;
import github.kasuminova.novaeng.common.integration.ic2.IntegrationIC2;
import github.kasuminova.novaeng.common.integration.theoneprobe.IntegrationTOP;
import github.kasuminova.novaeng.common.machine.GeocentricDrill;
import github.kasuminova.novaeng.common.machine.IllumPool;
import github.kasuminova.novaeng.common.machine.SingularityCore;
import github.kasuminova.novaeng.common.registry.RegistryBlocks;
import github.kasuminova.novaeng.common.registry.RegistryHyperNet;
import github.kasuminova.novaeng.common.registry.RegistryItems;
import github.kasuminova.novaeng.common.registry.RegistryMachineSpecial;
import github.kasuminova.novaeng.common.tile.TileHyperNetTerminal;
import github.kasuminova.novaeng.common.tile.TileModularServerAssembler;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorController;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorPatternBus;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageController;
import github.kasuminova.novaeng.common.tile.machine.GeocentricDrillController;
import github.kasuminova.novaeng.common.util.MachineCoolants;
import github.kasuminova.novaeng.mixin.ae2.AccessorCellRegistry;
import hellfirepvp.modularmachinery.common.base.Mods;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class CommonProxy
implements IGuiHandler {
    public CommonProxy() {
        MinecraftForge.EVENT_BUS.register((Object)new RegistryBlocks());
        MinecraftForge.EVENT_BUS.register((Object)new RegistryItems());
    }

    public void construction() {
    }

    public void preInit() {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)"novaeng_core", (IGuiHandler)this);
        MinecraftForge.EVENT_BUS.register((Object)IntegrationCRT.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)HyperNetEventHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)EStorageEventHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)EFabricatorEventHandler.INSTANCE);
        if (Loader.isModLoaded((String)"ic2")) {
            IntegrationIC2.preInit();
        }
    }

    public void init() {
        RegistryHyperNet.registerHyperNetNode(new ResourceLocation("modularmachinery", "hypernet_terminal"), HyperNetTerminal.class);
        IntegrationTOP.registerProvider();
        RecipeAdapterExtended.registerAdapter();
        AssemblyLine.registerNetNode();
        HyperNetRecipeManager.registerRecipes();
        if (Mods.ASTRAL_SORCERY.isPresent() && Mods.BOTANIA.isPresent()) {
            RegistryMachineSpecial.registrySpecialMachine(IllumPool.ILLUM_POOL);
        }
        if (Mods.GECKOLIB.isPresent()) {
            RegistryMachineSpecial.registrySpecialMachine(SingularityCore.SINGULARITY_CORE);
        }
        RegistryMachineSpecial.registrySpecialMachine(GeocentricDrill.GEOCENTRIC_DRILL);
        if (Mods.AE2.isPresent()) {
            List<ICellHandler> handlers = ((AccessorCellRegistry)AEApi.instance().registries().cell()).getHandlers();
            handlers.add(0, (ICellHandler)EStorageCellHandler.INSTANCE);
        }
    }

    public void postInit() {
        MachineCoolants.INSTANCE.init();
        HyperNetMachineEventHandler.registerHandler();
    }

    public void loadComplete() {
    }

    @Nullable
    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        Object object;
        GuiType type = GuiType.values()[MathHelper.func_76125_a((int)ID, (int)0, (int)(GuiType.values().length - 1))];
        Class<? extends TileEntity> required = type.requiredTileEntity;
        TileEntity present = null;
        if (required != null) {
            TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
            if (te != null && required.isAssignableFrom(te.getClass())) {
                present = te;
            } else {
                return null;
            }
        }
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case HYPERNET_TERMINAL: {
                object = new ContainerHyperNetTerminal((TileHyperNetTerminal)present, player);
                break;
            }
            case MODULAR_SERVER_ASSEMBLER: {
                object = new ContainerModularServerAssembler((TileModularServerAssembler)present, player);
                break;
            }
            case ESTORAGE_CONTROLLER: {
                object = new ContainerEStorageController((EStorageController)present, player);
                break;
            }
            case SINGULARITY_CORE: {
                object = new ContainerSingularityCore((github.kasuminova.novaeng.common.tile.machine.SingularityCore)present, player);
                break;
            }
            case EFABRICATOR_CONTROLLER: {
                EFabricatorController efController = (EFabricatorController)present;
                if (efController.getChannel() != null && ModIntegrationAE2.securityCheck((EntityPlayer)player, (AENetworkProxy)efController.getChannel().getProxy())) {
                    object = null;
                    break;
                }
                object = new ContainerEFabricatorController(efController, player);
                break;
            }
            case EFABRICATOR_PATTERN_BUS: {
                EFabricatorPatternBus efPatternBus = (EFabricatorPatternBus)present;
                EFabricatorController efController = (EFabricatorController)((Object)efPatternBus.getController());
                if (efController != null && efController.getChannel() != null && ModIntegrationAE2.securityCheck((EntityPlayer)player, (AENetworkProxy)efController.getChannel().getProxy())) {
                    object = null;
                    break;
                }
                object = new ContainerEFabricatorPatternBus(efPatternBus, player);
                break;
            }
            case CRAFTING_TREE: {
                Container container = player.field_71070_bA;
                if (!(container instanceof ContainerCraftConfirm)) {
                    object = null;
                    break;
                }
                ContainerCraftConfirm confirm = (ContainerCraftConfirm)container;
                object = new ContainerCraftingTree(player.field_71071_by, (ITerminalHost)confirm.getTarget());
                break;
            }
            case GEOCENTRIC_DRILL_CONTROLLER: {
                object = new ContainerGeocentricDrill((GeocentricDrillController)present, player);
            }
        }
        return object;
    }

    @Nullable
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public static enum GuiType {
        HYPERNET_TERMINAL(TileHyperNetTerminal.class),
        MODULAR_SERVER_ASSEMBLER(TileModularServerAssembler.class),
        ESTORAGE_CONTROLLER(EStorageController.class),
        SINGULARITY_CORE(github.kasuminova.novaeng.common.tile.machine.SingularityCore.class),
        EFABRICATOR_CONTROLLER(EFabricatorController.class),
        EFABRICATOR_PATTERN_BUS(EFabricatorPatternBus.class),
        CRAFTING_TREE(null),
        GEOCENTRIC_DRILL_CONTROLLER(GeocentricDrillController.class);

        public final Class<? extends TileEntity> requiredTileEntity;

        private GuiType(Class<? extends TileEntity> requiredTileEntity) {
            this.requiredTileEntity = requiredTileEntity;
        }
    }
}

