/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.client.util;

import github.kasuminova.novaeng.NovaEngineeringCore;
import github.kasuminova.novaeng.client.hitokoto.HitokotoAPI;
import github.kasuminova.novaeng.common.config.NovaEngCoreConfig;
import github.kasuminova.novaeng.mixin.NovaEngCoreEarlyMixinLoader;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import org.lwjgl.opengl.Display;

public class TitleUtils {
    public static final String DEFAULT_TITLE = "Nova Engineering: World 1.15.3 by Hikari_Nova | Core Ver: 1.19.1";
    public static final String VANILLA_TITLE = "Minecraft 1.12.2";
    public static String currentTitle = null;
    public static String lastCurrentTitle = null;
    public static boolean unsupportedPlatform = false;

    public static void setRandomTitle(String state) {
        lastCurrentTitle = currentTitle;
        if (!NovaEngCoreConfig.CLIENT.enableNovaEngTitle) {
            return;
        }
        String hitokotoCache = HitokotoAPI.getHitokotoCache();
        if (hitokotoCache != null) {
            currentTitle = TitleUtils.buildTitle(state, hitokotoCache);
            TitleUtils.setTitle();
        } else {
            CompletableFuture.runAsync(HitokotoAPI::getRandomHitokoto);
            currentTitle = TitleUtils.buildTitle(state, null);
            TitleUtils.setTitle();
        }
    }

    public static void setRandomTitle() {
        lastCurrentTitle = currentTitle;
        if (!NovaEngCoreConfig.CLIENT.enableNovaEngTitle) {
            return;
        }
        String hitokotoCache = HitokotoAPI.getHitokotoCache();
        if (hitokotoCache != null) {
            currentTitle = TitleUtils.buildTitle(null, hitokotoCache);
            TitleUtils.setTitle();
        } else {
            currentTitle = TitleUtils.buildTitle(null, null);
            TitleUtils.setTitle();
        }
    }

    public static void setRandomTitleSync(String state) {
        lastCurrentTitle = currentTitle;
        currentTitle = TitleUtils.buildTitle(state, HitokotoAPI.getHitokotoCache());
    }

    public static void setRandomTitleSync() {
        lastCurrentTitle = currentTitle;
        currentTitle = TitleUtils.buildTitle(null, HitokotoAPI.getHitokotoCache());
    }

    public static String buildTitle(String state, String hitokoto) {
        if (state == null) {
            if (hitokoto == null) {
                currentTitle = String.format("%s", DEFAULT_TITLE);
            }
            return String.format("%s | %s", DEFAULT_TITLE, hitokoto);
        }
        if (hitokoto == null) {
            return String.format("%s | %s", DEFAULT_TITLE, state);
        }
        return String.format("%s | %s | %s", DEFAULT_TITLE, state, hitokoto);
    }

    public static void checkTitleState() {
        if (currentTitle == null) {
            return;
        }
        String title = Display.getTitle();
        if (!(title.equals(currentTitle) || title.equals(VANILLA_TITLE) || title.equals(lastCurrentTitle))) {
            NovaEngineeringCore.log.debug("Invalid title: {}, Excepted: {}", (Object)title, (Object)lastCurrentTitle);
        }
        TitleUtils.setTitle();
    }

    private static void setTitle() {
        if (!NovaEngCoreConfig.CLIENT.enableNovaEngTitle) {
            return;
        }
        if (NovaEngCoreEarlyMixinLoader.isCleanroomLoader() && !unsupportedPlatform) {
            try {
                Class<?> Display2 = Class.forName("org.lwjgl.opengl.Display");
                Method getWindow = Display2.getDeclaredMethod("getWindow", new Class[0]);
                long result = (Long)getWindow.invoke(null, new Object[0]);
                if (result != 0L) {
                    Class<?> GLFW = Class.forName("org.lwjgl3.glfw.GLFW");
                    Method glfwSetWindowTitle = GLFW.getDeclaredMethod("glfwSetWindowTitle", Long.TYPE, CharSequence.class);
                    glfwSetWindowTitle.invoke(null, result, currentTitle);
                }
            }
            catch (Exception e) {
                NovaEngineeringCore.log.warn("Failed to set CleanroomLoader title, maybe platform is unsupported.", (Throwable)e);
                unsupportedPlatform = true;
            }
            return;
        }
        Display.setTitle((String)currentTitle);
    }
}

