/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.client.renderer;

import github.kasuminova.novaeng.common.block.ecotech.estorage.prop.EnergyCellStatus;
import github.kasuminova.novaeng.common.item.estorage.ItemBlockEStorageEnergyCell;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageEnergyCell;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class EStorageEnergyCellItemRenderer
implements ItemMeshDefinition {
    protected final ResourceLocation modelLocation;

    public EStorageEnergyCellItemRenderer(ItemBlockEStorageEnergyCell item, String level) {
        this.modelLocation = new ResourceLocation("novaeng_core", "estorage_energy_cell_" + level);
        for (EnergyCellStatus status : EnergyCellStatus.values()) {
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(this.modelLocation, "facing=north," + EnergyCellStatus.STATUS.func_177701_a() + "=" + status.func_176610_l())});
        }
    }

    @Nonnull
    public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
        double fillFactor = EStorageEnergyCellItemRenderer.getFillFactor(stack);
        EnergyCellStatus status = EStorageEnergyCell.getStatusFromFillFactor(fillFactor);
        return new ModelResourceLocation(this.modelLocation, "facing=north," + EnergyCellStatus.STATUS.func_177701_a() + "=" + status.func_176610_l());
    }

    private static double getFillFactor(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || tag.func_82582_d()) {
            return 0.0;
        }
        double maxEnergyStore = tag.func_74769_h("maxEnergyStore");
        if (maxEnergyStore <= 0.0) {
            return 0.0;
        }
        double energyStored = tag.func_74769_h("energyStored");
        if (energyStored <= 0.0) {
            return 0.0;
        }
        return energyStored / maxEnergyStore;
    }
}

