/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.client.hitokoto;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import github.kasuminova.novaeng.client.hitokoto.HitokotoDeserializer;
import github.kasuminova.novaeng.client.hitokoto.HitokotoResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import net.minecraft.util.JsonUtils;

public class HitokotoAPI {
    public static final String API_URL = "https://v1.hitokoto.cn/";
    public static String hitokotoCache = null;
    private static final Gson DESERIALIZER = new GsonBuilder().registerTypeHierarchyAdapter(HitokotoResult.class, (Object)new HitokotoDeserializer()).create();

    public static String getHitokotoCache() {
        return hitokotoCache;
    }

    public static String getRandomHitokoto() {
        HitokotoResult hitokoto;
        String jsonStr;
        if (hitokotoCache != null) {
            return hitokotoCache;
        }
        try {
            jsonStr = HitokotoAPI.getStringFromURL(API_URL);
        }
        catch (IOException e) {
            return "";
        }
        if (jsonStr == null || jsonStr.isEmpty()) {
            return "";
        }
        try {
            hitokoto = (HitokotoResult)JsonUtils.func_193837_a((Gson)DESERIALIZER, (String)jsonStr, HitokotoResult.class, (boolean)true);
        }
        catch (Exception e) {
            return "";
        }
        if (hitokoto == null) {
            return "";
        }
        String assembled = HitokotoAPI.assembleHitokoto(hitokoto);
        if (!assembled.isEmpty()) {
            hitokotoCache = assembled;
        }
        return assembled;
    }

    public static String assembleHitokoto(HitokotoResult result) {
        String hitokoto = result.getHitokoto();
        String fromWho = result.getFromWho();
        if (fromWho.isEmpty() && (fromWho = result.getFrom()).isEmpty()) {
            fromWho = result.getCreator();
        }
        if (hitokoto != null && fromWho != null) {
            return hitokoto + " \u2014\u2014 " + fromWho;
        }
        return "";
    }

    public static String getStringFromURL(String urlStr) throws IOException {
        try {
            String line;
            URL url = new URL(urlStr);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
            reader.close();
            connection.disconnect();
            return stringBuilder.toString();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

