/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.client.handler;

import github.kasuminova.novaeng.common.hypernet.computer.module.ServerModule;
import github.kasuminova.novaeng.common.hypernet.computer.module.base.ServerModuleBase;
import github.kasuminova.novaeng.common.registry.RegistryHyperNet;
import github.kasuminova.novaeng.common.registry.ServerModuleRegistry;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HyperNetClientEventHandler {
    public static final HyperNetClientEventHandler INSTANCE = new HyperNetClientEventHandler();
    protected final Map<ItemStack, ServerModule> moduleCache = new WeakHashMap<ItemStack, ServerModule>();

    private HyperNetClientEventHandler() {
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onItemTooltip(ItemTooltipEvent event) {
        Item matches = RegistryHyperNet.getHyperNetConnectCard();
        if (matches == Items.field_190931_a) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() != matches) {
            return;
        }
        NBTTagCompound tag = stack.func_77978_p();
        List tips = event.getToolTip();
        tips.add(I18n.func_135052_a((String)"item.hypernet_connect_card.tooltip.1", (Object[])new Object[0]));
        tips.add(I18n.func_135052_a((String)"item.hypernet_connect_card.tooltip.2", (Object[])new Object[0]));
        tips.add(I18n.func_135052_a((String)"item.hypernet_connect_card.tooltip.3", (Object[])new Object[0]));
        tips.add(I18n.func_135052_a((String)"item.hypernet_connect_card.tooltip.4", (Object[])new Object[0]));
        if (tag == null || !tag.func_74764_b("pos")) {
            tips.add(I18n.func_135052_a((String)"item.hypernet_connect_card.tooltip.no_pos.tip.0", (Object[])new Object[0]));
            tips.add(I18n.func_135052_a((String)"item.hypernet_connect_card.tooltip.no_pos.tip.1", (Object[])new Object[0]));
        } else {
            BlockPos pos = BlockPos.func_177969_a((long)tag.func_74763_f("pos"));
            tips.add(I18n.func_135052_a((String)"item.hypernet_connect_card.tooltip.pos.tip.0", (Object[])new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}));
            tips.add(I18n.func_135052_a((String)"item.hypernet_connect_card.tooltip.pos.tip.1", (Object[])new Object[0]));
        }
    }

    @SubscribeEvent
    public void onServerModuleItemTooltip(ItemTooltipEvent event) {
        ServerModuleBase<?> moduleBase;
        ItemStack stack = event.getItemStack();
        if (stack.func_190926_b()) {
            return;
        }
        ServerModule cachedModule = this.moduleCache.get(stack);
        if (cachedModule == null) {
            moduleBase = ServerModuleRegistry.getModule(stack);
            if (moduleBase == null) {
                return;
            }
            cachedModule = moduleBase.createInstance(null, stack);
        }
        this.moduleCache.put(stack, cachedModule);
        moduleBase = cachedModule.getModuleBase();
        event.getToolTip().addAll(moduleBase.getTooltip(cachedModule));
    }
}

