/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.client.handler;

import github.kasuminova.novaeng.client.util.TitleUtils;
import github.kasuminova.novaeng.common.config.NovaEngCoreConfig;
import github.kasuminova.novaeng.common.profiler.CPacketProfiler;
import github.kasuminova.novaeng.common.profiler.TEUpdatePacketProfiler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

public class ClientEventHandler {
    public static final ClientEventHandler INSTANCE = new ClientEventHandler();
    public static int debugPacketProfilerMessageLimit = 5;
    public static int debugTEPacketProfilerMessageLimit = 5;
    private long clientTick = 0L;
    private final List<String> debugMessageCache = new ArrayList<String>();
    private boolean debugMessageUpdateRequired = true;

    private ClientEventHandler() {
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        ++this.clientTick;
        if (this.clientTick % 5L == 0L) {
            if (NovaEngCoreConfig.CLIENT.enableNovaEngTitle) {
                TitleUtils.checkTitleState();
            }
            this.debugMessageUpdateRequired = true;
        }
    }

    @SubscribeEvent
    public void onDebugText(RenderGameOverlayEvent.Text event) {
        if (!Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            return;
        }
        if (this.debugMessageUpdateRequired) {
            this.debugMessageUpdateRequired = false;
            this.debugMessageCache.clear();
            this.debugMessageCache.add("");
            this.debugMessageCache.add(TextFormatting.BLUE + "[NovaEngineering-Core] Ver: " + "1.19.1");
            this.debugMessageCache.addAll(CPacketProfiler.getProfilerMessages(debugPacketProfilerMessageLimit));
            this.debugMessageCache.addAll(TEUpdatePacketProfiler.getProfilerMessages(debugTEPacketProfilerMessageLimit));
        }
        ArrayList right = event.getRight();
        right.addAll(this.debugMessageCache);
    }

    @SubscribeEvent
    public void onServerConnected(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        CPacketProfiler.enabled = true;
        CPacketProfiler.PACKET_TOTAL_SIZE.clear();
        CPacketProfiler.TOTAL_RECEIVED_DATA_SIZE.set(0L);
        CPacketProfiler.profilerStartTime = System.currentTimeMillis();
        TEUpdatePacketProfiler.TE_UPDATE_PACKET_TOTAL_SIZE.clear();
        TitleUtils.setRandomTitleSync(String.format("*%s*", event.getManager().func_74430_c()));
    }

    @SubscribeEvent
    public void onServerDisconnected(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        CPacketProfiler.enabled = false;
        CPacketProfiler.profilerStopTime = System.currentTimeMillis();
        TitleUtils.setRandomTitleSync();
    }
}

