/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.client.gui.widget.msa.slot;

import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.event.GuiEvent;
import github.kasuminova.novaeng.client.gui.widget.msa.event.AssemblerInvUpdateEvent;
import github.kasuminova.novaeng.client.gui.widget.msa.event.AssemblyInvCloseEvent;
import github.kasuminova.novaeng.client.gui.widget.msa.event.AssemblyInvOpenEvent;
import github.kasuminova.novaeng.client.gui.widget.msa.slot.SlotDynamic;
import github.kasuminova.novaeng.common.container.slot.AssemblySlotManager;
import github.kasuminova.novaeng.common.container.slot.SlotConditionItemHandler;
import github.kasuminova.novaeng.common.hypernet.computer.ModularServer;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;

public abstract class SlotAssembly<T extends SlotConditionItemHandler>
extends SlotDynamic<T> {
    protected AssemblySlotManager slotManager;

    public SlotAssembly(int slotID, AssemblySlotManager slotManager) {
        super(slotID);
        this.slotManager = slotManager;
    }

    public void update(WidgetGui gui) {
        super.update(gui);
        if (this.slot != null) {
            this.slot.setEnabled(this.isAvailable());
        }
    }

    public void postRender(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        super.postRender(gui, renderSize, renderPos, mousePos);
        if (this.slot == null) {
            return;
        }
        if (this.isAvailable() && this.slot.isInvalid()) {
            Gui.func_73734_a((int)(renderPos.posX() + 1), (int)(renderPos.posY() + 1), (int)(renderPos.posX() + 17), (int)(renderPos.posY() + 17), (int)-2130733418);
            return;
        }
        for (SlotConditionItemHandler dependency : this.slot.getDependencies()) {
            if (!SlotAssembly.renderDependiceColorOverlay(renderPos, dependency)) continue;
            return;
        }
        for (SlotConditionItemHandler dependent : this.slot.getDependents()) {
            if (!this.renderDependencyColorOverlay(renderPos, dependent)) continue;
            return;
        }
        for (SlotConditionItemHandler dependency : this.slot.getSoftDependencies()) {
            if (!SlotAssembly.renderDependiceColorOverlay(renderPos, dependency)) continue;
            return;
        }
        for (SlotConditionItemHandler dependent : this.slot.getSoftDependents()) {
            if (!this.renderDependencyColorOverlay(renderPos, dependent)) continue;
            return;
        }
    }

    private boolean renderDependencyColorOverlay(RenderPos renderPos, SlotConditionItemHandler dependent) {
        if (dependent.isHovered()) {
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            if (this.isInstalled()) {
                Gui.func_73734_a((int)(renderPos.posX() + 1), (int)(renderPos.posY() + 1), (int)(renderPos.posX() + 17), (int)(renderPos.posY() + 17), (int)-2130706538);
            } else {
                Gui.func_73734_a((int)(renderPos.posX() + 1), (int)(renderPos.posY() + 1), (int)(renderPos.posX() + 17), (int)(renderPos.posY() + 17), (int)-2130733418);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            return true;
        }
        return false;
    }

    private static boolean renderDependiceColorOverlay(RenderPos renderPos, SlotConditionItemHandler dependency) {
        if (dependency.isHovered()) {
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            Gui.func_73734_a((int)(renderPos.posX() + 1), (int)(renderPos.posY() + 1), (int)(renderPos.posX() + 17), (int)(renderPos.posY() + 17), (int)-2137587818);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            return true;
        }
        return false;
    }

    @Override
    public boolean onGuiEvent(GuiEvent event) {
        if (event instanceof AssemblerInvUpdateEvent) {
            AssemblerInvUpdateEvent serverUpdateEvent = (AssemblerInvUpdateEvent)event;
            ModularServer server = serverUpdateEvent.getServer();
            this.slotManager = server == null ? null : server.getSlotManager();
        } else if (this.slot != null) {
            if (event instanceof AssemblyInvCloseEvent) {
                this.slot.setEnabled(false);
            } else if (event instanceof AssemblyInvOpenEvent) {
                this.slot.setEnabled(true);
            }
        }
        return super.onGuiEvent(event);
    }

    @Override
    public boolean isAvailable() {
        return this.slot != null && this.slot.isAvailable();
    }

    public boolean isInstalled() {
        return this.slot != null && this.slot.func_75216_d();
    }

    public List<String> getHoverTooltips(MousePos mousePos) {
        return this.slot == null ? Collections.emptyList() : this.slot.getHoverTooltips();
    }
}

