/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.client.gui.widget.msa;

import github.kasuminova.mmce.client.gui.widget.HorizontalLine;
import github.kasuminova.mmce.client.gui.widget.MultiLineLabel;
import github.kasuminova.mmce.client.gui.widget.base.DynamicWidget;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.container.ScrollingColumn;
import github.kasuminova.mmce.client.gui.widget.event.GuiEvent;
import github.kasuminova.novaeng.client.gui.widget.msa.event.AssemblerInvUpdateEvent;
import github.kasuminova.novaeng.common.container.slot.AssemblySlotManager;
import github.kasuminova.novaeng.common.container.slot.SlotCPUItemHandler;
import github.kasuminova.novaeng.common.container.slot.SlotCalculateCardItemHandler;
import github.kasuminova.novaeng.common.container.slot.SlotCapacitorItemHandler;
import github.kasuminova.novaeng.common.container.slot.SlotConditionItemHandler;
import github.kasuminova.novaeng.common.container.slot.SlotExtensionCardItemHandler;
import github.kasuminova.novaeng.common.container.slot.SlotPSUItemHandler;
import github.kasuminova.novaeng.common.container.slot.SlotRAMItemHandler;
import github.kasuminova.novaeng.common.crafttweaker.util.NovaEngUtils;
import github.kasuminova.novaeng.common.hypernet.calculation.Calculable;
import github.kasuminova.novaeng.common.hypernet.calculation.CalculateRequest;
import github.kasuminova.novaeng.common.hypernet.calculation.CalculateStage;
import github.kasuminova.novaeng.common.hypernet.calculation.CalculateType;
import github.kasuminova.novaeng.common.hypernet.calculation.CalculateTypes;
import github.kasuminova.novaeng.common.hypernet.calculation.modifier.ModifierManager;
import github.kasuminova.novaeng.common.hypernet.computer.ModularServer;
import github.kasuminova.novaeng.common.util.TileItemHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.resources.I18n;
import net.minecraft.tileentity.TileEntity;

public class ServerInfoColumn
extends ScrollingColumn {
    protected ModularServer server;

    public ServerInfoColumn(ModularServer server) {
        this.server = server;
    }

    protected static int getInstalledSlots(TileItemHandler inv, AssemblySlotManager slotManager, String invName, Predicate<SlotConditionItemHandler> slotFilter) {
        int[] installedSlots = new int[]{0};
        inv.getAvailableSlotsStream().mapToObj(slotID -> slotManager.getSlot(invName, slotID)).filter(slotFilter).filter(SlotConditionItemHandler::isInstalled).forEach(slot -> {
            installedSlots[0] = installedSlots[0] + 1;
        });
        return installedSlots[0];
    }

    protected static void addUninstalledDependenciesTip(TileItemHandler inv, AssemblySlotManager slotManager, String invName, List<String> tip) {
        inv.getAvailableSlotsStream().mapToObj(slotID -> slotManager.getSlot(invName, slotID)).filter(SlotConditionItemHandler::isInstalled).forEach(slot -> {
            slot.getDependencies().stream().filter(dependency -> !dependency.isInstalled()).map(dependency -> dependency.getSlotDescription() + I18n.func_135052_a((String)"gui.modular_server_assembler.assembly.dependencies.uninstalled", (Object[])new Object[0])).forEach(tip::add);
            slot.getSoftDependencies().stream().filter(softDependency -> !softDependency.isInstalled()).map(softDependency -> softDependency.getSlotDescription() + I18n.func_135052_a((String)"gui.modular_server_assembler.assembly.dependencies.uninstalled", (Object[])new Object[0])).forEach(tip::add);
        });
    }

    protected static void addUninstalledDependenciesTip(TileItemHandler cpu, AssemblySlotManager slotManager, TileItemHandler calculateCard, TileItemHandler extension, TileItemHandler power, List<String> errorTips) {
        ArrayList<String> uninstalledDependenciesTip = new ArrayList<String>();
        ServerInfoColumn.addUninstalledDependenciesTip(cpu, slotManager, "cpu", uninstalledDependenciesTip);
        ServerInfoColumn.addUninstalledDependenciesTip(calculateCard, slotManager, "calculate_card", uninstalledDependenciesTip);
        ServerInfoColumn.addUninstalledDependenciesTip(extension, slotManager, "extension", uninstalledDependenciesTip);
        ServerInfoColumn.addUninstalledDependenciesTip(power, slotManager, "power", uninstalledDependenciesTip);
        if (!uninstalledDependenciesTip.isEmpty()) {
            errorTips.add(I18n.func_135052_a((String)"gui.modular_server_assembler.error.dependencies.0", (Object[])new Object[0]));
            errorTips.add(I18n.func_135052_a((String)"gui.modular_server_assembler.error.dependencies.1", (Object[])new Object[0]));
            errorTips.addAll(uninstalledDependenciesTip);
        }
    }

    public void initWidget(WidgetGui gui) {
        super.initWidget(gui);
        this.updateTips();
    }

    protected void updateTips() {
        this.widgets.clear();
        if (this.server == null) {
            this.addWidget((DynamicWidget)this.createLabel(Collections.singletonList(I18n.func_135052_a((String)"gui.modular_server_assembler.info.missing_server", (Object[])new Object[0]))));
            return;
        }
        AssemblySlotManager slotManager = this.server.getSlotManager();
        TileItemHandler cpu = this.server.getInvByName("cpu");
        TileItemHandler calculateCard = this.server.getInvByName("calculate_card");
        TileItemHandler extension = this.server.getInvByName("extension");
        TileItemHandler power = this.server.getInvByName("power");
        int installedCPUModules = ServerInfoColumn.getInstalledSlots(cpu, slotManager, "cpu", SlotCPUItemHandler.class::isInstance);
        int installedRAMModules = ServerInfoColumn.getInstalledSlots(cpu, slotManager, "cpu", SlotRAMItemHandler.class::isInstance);
        int installedCalculateCardModules = ServerInfoColumn.getInstalledSlots(calculateCard, slotManager, "calculate_card", SlotCalculateCardItemHandler.class::isInstance);
        int installedExtensionCardModules = ServerInfoColumn.getInstalledSlots(extension, slotManager, "extension", SlotExtensionCardItemHandler.class::isInstance);
        int installedPSUModules = ServerInfoColumn.getInstalledSlots(power, slotManager, "power", SlotPSUItemHandler.class::isInstance);
        int installedCapacitorModules = ServerInfoColumn.getInstalledSlots(power, slotManager, "power", SlotCapacitorItemHandler.class::isInstance);
        int totalInstalledModules = this.server.getModules().size();
        this.addModuleTips(totalInstalledModules, installedCPUModules, installedRAMModules, installedCalculateCardModules, installedExtensionCardModules, installedPSUModules, installedCapacitorModules);
        this.addPropertiesTips();
        this.addHardwareBandwidthTips();
        LinkedList<String> errorTips = new LinkedList<String>();
        this.addErrorTips(installedCPUModules, errorTips, installedRAMModules, installedPSUModules, installedCapacitorModules, cpu, slotManager, calculateCard, extension, power);
        this.addWidget((DynamicWidget)this.createLabel(Collections.singletonList(I18n.func_135052_a((String)"gui.modular_server_assembler.info.can_start", (Object[])new Object[]{I18n.func_135052_a((String)("gui.modular_server_assembler.info.can_start." + (errorTips.isEmpty() ? "true" : "false")), (Object[])new Object[0])}))));
        if (!errorTips.isEmpty()) {
            errorTips.add(0, I18n.func_135052_a((String)"gui.modular_server_assembler.error", (Object[])new Object[0]));
            this.addWidget((DynamicWidget)this.createLabel(errorTips));
            return;
        }
        this.addWidget((DynamicWidget)this.createSeparator());
        this.addExpectedCalculateTip();
    }

    private void addModuleTips(int totalInstalledModules, int installedCPUModules, int installedRAMModules, int installedCalculateCardModules, int installedExtensionCardModules, int installedPSUModules, int installedCapacitorModules) {
        this.addWidget((DynamicWidget)this.createLabel(Collections.singletonList(I18n.func_135052_a((String)"gui.modular_server_assembler.info.total_modules", (Object[])new Object[]{totalInstalledModules}))));
        ArrayList<String> moduleTips = new ArrayList<String>();
        moduleTips.add(I18n.func_135052_a((String)"gui.modular_server_assembler.info.total_cpus", (Object[])new Object[]{installedCPUModules}));
        moduleTips.add(I18n.func_135052_a((String)"gui.modular_server_assembler.info.total_rams", (Object[])new Object[]{installedRAMModules}));
        moduleTips.add(I18n.func_135052_a((String)"gui.modular_server_assembler.info.total_calculate_cards", (Object[])new Object[]{installedCalculateCardModules}));
        moduleTips.add(I18n.func_135052_a((String)"gui.modular_server_assembler.info.total_extensions", (Object[])new Object[]{installedExtensionCardModules}));
        moduleTips.add(I18n.func_135052_a((String)"gui.modular_server_assembler.info.total_psus", (Object[])new Object[]{installedPSUModules}));
        moduleTips.add(I18n.func_135052_a((String)"gui.modular_server_assembler.info.total_capacitors", (Object[])new Object[]{installedCapacitorModules}));
        this.addWidget((DynamicWidget)this.createLabel(moduleTips));
        this.addWidget((DynamicWidget)this.createSeparator());
    }

    protected void addHardwareBandwidthTips() {
        ArrayList<String> hardwareBandwidthTips = new ArrayList<String>();
        int totalHardwareBandwidth = this.server.getTotalHardwareBandwidth();
        int usedHardwareBandwidth = this.server.getUsedHardwareBandwidth();
        hardwareBandwidthTips.add(I18n.func_135052_a((String)"gui.modular_server_assembler.info.total_hardware_bandwidth", (Object[])new Object[]{totalHardwareBandwidth}));
        if (totalHardwareBandwidth <= 0) {
            hardwareBandwidthTips.add(I18n.func_135052_a((String)"gui.modular_server_assembler.info.used_hardware_bandwidth", (Object[])new Object[]{usedHardwareBandwidth, usedHardwareBandwidth > 0 ? "100%" : "0%"}));
        } else {
            hardwareBandwidthTips.add(I18n.func_135052_a((String)"gui.modular_server_assembler.info.used_hardware_bandwidth", (Object[])new Object[]{usedHardwareBandwidth, NovaEngUtils.formatPercent(usedHardwareBandwidth, totalHardwareBandwidth)}));
        }
        this.addWidget((DynamicWidget)this.createLabel(hardwareBandwidthTips));
        this.addWidget((DynamicWidget)this.createSeparator());
    }

    protected void addPropertiesTips() {
        ArrayList<String> propertiesTips = new ArrayList<String>();
        propertiesTips.add(I18n.func_135052_a((String)"gui.modular_server_assembler.info.max_energy_cap", (Object[])new Object[]{NovaEngUtils.formatNumber(this.server.getMaxEnergyCap())}));
        propertiesTips.add(I18n.func_135052_a((String)"gui.modular_server_assembler.info.max_energy_consumption", (Object[])new Object[]{NovaEngUtils.formatNumber(this.server.getMaxEnergyConsumption())}));
        propertiesTips.add(I18n.func_135052_a((String)"gui.modular_server_assembler.info.max_energy_provision", (Object[])new Object[]{NovaEngUtils.formatNumber(this.server.getMaxEnergyProvision())}));
        this.addWidget((DynamicWidget)this.createLabel(propertiesTips));
        this.addWidget((DynamicWidget)this.createSeparator());
    }

    protected void addErrorTips(int installedCPUModules, List<String> errorTips, int installedRAMModules, int installedPSUModules, int installedCapacitorModules, TileItemHandler cpu, AssemblySlotManager slotManager, TileItemHandler calculateCard, TileItemHandler extension, TileItemHandler power) {
        int usedHardwareBandwidth;
        int totalHardwareBandwidth;
        if (installedCPUModules <= 0) {
            errorTips.add(I18n.func_135052_a((String)"gui.modular_server_assembler.error.require_cpu", (Object[])new Object[0]));
        }
        if (installedRAMModules <= 0) {
            errorTips.add(I18n.func_135052_a((String)"gui.modular_server_assembler.error.require_ram", (Object[])new Object[0]));
        }
        if (installedPSUModules <= 0) {
            errorTips.add(I18n.func_135052_a((String)"gui.modular_server_assembler.error.require_psu", (Object[])new Object[0]));
        }
        if (installedCapacitorModules <= 0) {
            errorTips.add(I18n.func_135052_a((String)"gui.modular_server_assembler.error.require_capacitor", (Object[])new Object[0]));
        }
        if ((double)(totalHardwareBandwidth = this.server.getTotalHardwareBandwidth()) * 1.5 < (double)(usedHardwareBandwidth = this.server.getUsedHardwareBandwidth())) {
            errorTips.add(I18n.func_135052_a((String)"gui.modular_server_assembler.error.hardware_bandwidth", (Object[])new Object[0]));
        }
        ServerInfoColumn.addUninstalledDependenciesTip(cpu, slotManager, calculateCard, extension, power, errorTips);
    }

    protected void addExpectedCalculateTip() {
        ArrayList<String> tip = new ArrayList<String>();
        tip.add(I18n.func_135052_a((String)"gui.modular_server_assembler.calculate.expected", (Object[])new Object[0]));
        for (CalculateType type : CalculateTypes.getAvailableTypes().values()) {
            tip.add(I18n.func_135052_a((String)"gui.modular_server_assembler.calculate.name", (Object[])new Object[]{type.getFormattedTypeName()}));
            tip.add(I18n.func_135052_a((String)"gui.modular_server_assembler.calculate.value", (Object[])new Object[]{type.format(this.server.calculate(new CalculateRequest(Double.MAX_VALUE, true, type, CalculateStage.START, (TileEntity)this.server.getOwner(), new ModifierManager(), new HashMap<String, Object>())).generated()), Calculable.formatEfficiency(this.server.getCalculateAvgEfficiency(type))}));
        }
        this.addWidget((DynamicWidget)this.createLabel(tip));
        this.addWidget((DynamicWidget)this.createSeparator());
    }

    protected HorizontalLine createSeparator() {
        return (HorizontalLine)new HorizontalLine().setWidth(this.width - 8 - 4).setHeight(1).setMarginLeft(2);
    }

    protected MultiLineLabel createLabel(List<String> contents) {
        return new MultiLineLabel(contents).setWidth(this.width - 8 - 4).setScale(0.8f);
    }

    public boolean onGuiEvent(GuiEvent event) {
        if (event instanceof AssemblerInvUpdateEvent) {
            AssemblerInvUpdateEvent serverUpdateEvent = (AssemblerInvUpdateEvent)event;
            this.server = serverUpdateEvent.getServer();
            this.updateTips();
        }
        return super.onGuiEvent(event);
    }
}

