/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.client.gui.widget.geocentricdrill;

import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.slot.SlotItemVirtualJEI;
import github.kasuminova.novaeng.NovaEngineeringCore;
import github.kasuminova.novaeng.common.crafttweaker.util.NovaEngUtils;
import github.kasuminova.novaeng.common.network.PktGeocentricDrillControl;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SlotOreControl
extends SlotItemVirtualJEI {
    private final String oreName;
    private float chance;
    private boolean accelerated;

    public SlotOreControl(String oreName, ItemStack stackInSlot, float chance, boolean accelerated) {
        super(stackInSlot);
        this.oreName = oreName;
        this.chance = chance;
        this.accelerated = accelerated;
    }

    public List<String> getHoverTooltips(WidgetGui widgetGui, MousePos mousePos) {
        List tooltips = super.getHoverTooltips(widgetGui, mousePos);
        if (!tooltips.isEmpty()) {
            float chance = (this.accelerated ? this.chance * 15.0f : this.chance) * 100.0f;
            tooltips.add(I18n.func_135052_a((String)"gui.geocentric_drill.ore_control.tooltip.chance", (Object[])new Object[]{NovaEngUtils.formatFloat(chance, 1)}));
            tooltips.add(this.accelerated ? I18n.func_135052_a((String)"gui.geocentric_drill.ore_control.tooltip.unmark", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.geocentric_drill.ore_control.tooltip.mark", (Object[])new Object[0]));
        }
        return tooltips;
    }

    public void render(WidgetGui widgetGui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        super.render(widgetGui, renderSize, renderPos, mousePos);
        if (this.stackInSlot.func_190926_b()) {
            return;
        }
        Minecraft mc = widgetGui.getGui().field_146297_k;
        int rx = renderPos.posX() + 1;
        int ry = renderPos.posY() + 1;
        this.renderChance(mc.field_71466_p, rx, ry, this.chance);
    }

    protected void drawHoverOverlay(MousePos mousePos, int rx, int ry) {
        if (this.accelerated) {
            GlStateManager.func_179140_f();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GuiScreen.func_73734_a((int)rx, (int)ry, (int)(rx + 16), (int)(ry + 16), (int)new Color(255, 255, 50, 127).getRGB());
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179145_e();
        } else {
            super.drawHoverOverlay(mousePos, rx, ry);
        }
    }

    public void renderChance(FontRenderer fr, int xPos, int yPos, float chance) {
        float scale = 0.75f;
        float actualChance = (this.accelerated ? chance * 15.0f : chance) * 100.0f;
        String content = NovaEngUtils.formatFloat(actualChance, 1) + "%";
        GlStateManager.func_179140_f();
        GlStateManager.func_179084_k();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)160.0f);
        boolean unicodeFlag = fr.func_82883_a();
        fr.func_78264_a(false);
        fr.func_175063_a(content, ((float)(xPos + 16) - (float)fr.func_78256_a(content) * 0.75f) / 0.75f, (float)yPos / 0.75f, this.accelerated ? 0x7FFF00 : 0xFFFFFF);
        fr.func_78264_a(unicodeFlag);
        GlStateManager.func_179121_F();
        GlStateManager.func_179147_l();
    }

    public static SlotOreControl of(String oreName, ItemStack stackInSlot, float chance, boolean accelerated) {
        return new SlotOreControl(oreName, stackInSlot, chance, accelerated);
    }

    public boolean onMouseClick(MousePos mousePos, RenderPos renderPos, int mouseButton) {
        if (this.accelerated) {
            NovaEngineeringCore.NET_CHANNEL.sendToServer((IMessage)new PktGeocentricDrillControl(PktGeocentricDrillControl.Type.REMOVE_ACCELERATE_ORE, this.oreName));
        } else {
            NovaEngineeringCore.NET_CHANNEL.sendToServer((IMessage)new PktGeocentricDrillControl(PktGeocentricDrillControl.Type.ADD_ACCELERATE_ORE, this.oreName));
        }
        return true;
    }
}

