/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.client.gui.widget.geocentricdrill;

import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.container.Column;
import github.kasuminova.novaeng.common.crafttweaker.util.NovaEngUtils;
import github.kasuminova.novaeng.common.hypernet.old.NetNodeCache;
import github.kasuminova.novaeng.common.hypernet.old.NetNodeImpl;
import github.kasuminova.novaeng.common.tile.machine.GeocentricDrillController;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;

public class DrillMonitor
extends Column {
    public static final int WIDTH = 162;
    public static final int HEIGHT = 45;
    public static final int FONT_HEIGHT = 9;
    public static final float FONT_SCALE = 0.8f;
    public static final int TEXT_WIDTH = 197;
    private final GeocentricDrillController controller;

    public DrillMonitor(GeocentricDrillController controller) {
        this.width = 162;
        this.height = 45;
        this.controller = controller;
    }

    protected void renderInternal(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        int rx = renderPos.posX() + 2;
        int ry = renderPos.posY() + 2;
        FontRenderer fr = gui.getGui().field_146297_k.field_71466_p;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)rx, (float)ry, (float)0.0f);
        GlStateManager.func_179152_a((float)0.8f, (float)0.8f, (float)1.0f);
        ArrayList<List> contents = new ArrayList<List>();
        String status = I18n.func_135052_a((String)"gui.controller.status", (Object[])new Object[0]) + I18n.func_135052_a((String)this.controller.getControllerStatus().getUnlocMessage(), (Object[])new Object[0]);
        contents.add(fr.func_78271_c(status, 197));
        ArrayList subContents = new ArrayList();
        String depth = I18n.func_135052_a((String)"gui.geocentric_drill.monitor.depth", (Object[])new Object[]{NovaEngUtils.formatFloat(this.controller.getDepth(), 1), NovaEngUtils.formatDecimal(this.controller.getTargetDepth())});
        subContents.addAll(fr.func_78271_c(depth, 197));
        String outputMultiplier = I18n.func_135052_a((String)"gui.geocentric_drill.monitor.output_multiplier", (Object[])new Object[]{(int)this.controller.getDepth() / 16});
        subContents.addAll(fr.func_78271_c(outputMultiplier, 197));
        contents.add(subContents);
        subContents = new ArrayList();
        NetNodeImpl node = NetNodeCache.getCache((TileMultiblockMachineController)this.controller, NetNodeImpl.class);
        if (node != null && node.isConnected()) {
            String connected = I18n.func_135052_a((String)"gui.hypernet.controller.connected", (Object[])new Object[0]);
            subContents.addAll(fr.func_78271_c(connected, 197));
        } else {
            String disconnected = I18n.func_135052_a((String)"gui.hypernet.controller.disconnected", (Object[])new Object[0]);
            subContents.addAll(fr.func_78271_c(disconnected, 197));
        }
        String calculation = I18n.func_135052_a((String)"gui.hypernet.controller.computation_point_consumption", (Object[])new Object[0]) + NovaEngUtils.formatFLOPS(node.getComputationPointConsumption());
        subContents.addAll(fr.func_78271_c(calculation, 197));
        contents.add(subContents);
        ry = 0;
        for (List content : contents) {
            for (String line : content) {
                fr.func_78276_b(line, 0, ry, 0xFFFFFF);
                ry += 9;
            }
            ry += 3;
        }
        GlStateManager.func_179121_F();
        super.renderInternal(gui, renderSize, renderPos, mousePos);
    }

    public void update(WidgetGui gui) {
        super.update(gui);
        NetNodeImpl node = NetNodeCache.getCache((TileMultiblockMachineController)this.controller, NetNodeImpl.class);
        if (node != null) {
            node.readNBT();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

