/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.client.gui.widget.estorage;

import github.kasuminova.mmce.client.gui.util.AnimationValue;
import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.widget.MultiLineLabel;
import github.kasuminova.mmce.client.gui.widget.base.DynamicWidget;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.container.Column;
import github.kasuminova.mmce.client.gui.widget.event.GuiEvent;
import github.kasuminova.novaeng.client.gui.widget.estorage.EStorageGraph;
import github.kasuminova.novaeng.client.gui.widget.estorage.event.ESGraphFocusUpdateEvent;
import github.kasuminova.novaeng.common.util.RandomUtils;
import java.util.Collections;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public abstract class Graph
extends Column {
    public static final ResourceLocation BG_TEX_RES = new ResourceLocation("novaeng_core", "textures/gui/estorage_controller_elements.png");
    protected final EStorageGraph graphParent;
    protected final MultiLineLabel label;
    protected final AnimationValue value = AnimationValue.ofFinished((double)0.0, (int)500, (double)0.25, (double)0.1, (double)0.25, (double)1.0);
    protected final int bgTexX;
    protected final int bgTexY;
    protected final int bgTexWidth;
    protected final int bgTexHeight;
    protected final boolean reverseColor;
    protected boolean focused = false;

    public Graph(EStorageGraph graphParent, int absX, int absY, int width, int height, int randomOffset, int bgTexX, int bgTexY, int bgTexWidth, int bgTexHeight, boolean leftAlign, boolean reverseColor) {
        this.graphParent = graphParent;
        this.label = new MultiLineLabel(Collections.emptyList());
        this.bgTexX = bgTexX;
        this.bgTexY = bgTexY;
        this.bgTexWidth = bgTexWidth;
        this.bgTexHeight = bgTexHeight;
        this.width = width;
        this.height = height;
        this.reverseColor = reverseColor;
        this.label.setAutoWrap(false).setScale(0.6f).setVerticalCentering(true).setRightAligned(!leftAlign).setHeight(10).setMargin(2, 2, 0, 0);
        this.setRightAligned(!leftAlign);
        this.addWidget((DynamicWidget)this.label);
        this.setUseScissor(false);
        this.setAbsXY(absX + (RandomUtils.nextInt(randomOffset * 2) - randomOffset), absY + (RandomUtils.nextInt(randomOffset * 2) - randomOffset));
    }

    protected void preRenderInternal(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        if (this.isMouseOverGraphText(mousePos.mouseX(), mousePos.mouseY()) && !this.focused) {
            this.focused = true;
            this.graphParent.getControllerGUI().onGraphFocusUpdate(this);
            this.graphParent.getGraphBar().setPercentage(this.value, this.reverseColor);
        }
        super.preRenderInternal(gui, renderSize, renderPos, mousePos);
    }

    public boolean isMouseOverGraphText(int mouseX, int mouseY) {
        if (this.isInvisible()) {
            return false;
        }
        int endX = this.width;
        int endY = this.height - 6;
        return mouseX >= 0 && mouseX <= endX && mouseY >= 0 && mouseY <= endY;
    }

    protected void renderInternal(WidgetGui widgetGui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        if (!this.focused) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
        }
        GuiScreen gui = widgetGui.getGui();
        gui.field_146297_k.func_110434_K().func_110577_a(BG_TEX_RES);
        gui.func_73729_b(renderPos.posX(), renderPos.posY() + this.label.getHeight(), this.bgTexX, this.bgTexY, this.bgTexWidth, this.bgTexHeight);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.renderInternal(widgetGui, renderSize, renderPos, mousePos);
    }

    public boolean onGuiEvent(GuiEvent event) {
        ESGraphFocusUpdateEvent focusUpdateEvent;
        if (event instanceof ESGraphFocusUpdateEvent && (focusUpdateEvent = (ESGraphFocusUpdateEvent)event).getGraph() != this && this.focused) {
            this.focused = false;
        }
        return super.onGuiEvent(event);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

