/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.client.gui.widget.estorage;

import github.kasuminova.mmce.client.gui.util.AnimationValue;
import github.kasuminova.mmce.client.gui.widget.base.WidgetController;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.container.Row;
import github.kasuminova.mmce.client.gui.widget.container.WidgetContainer;
import github.kasuminova.mmce.client.gui.widget.event.GuiEvent;
import github.kasuminova.novaeng.client.gui.GuiEStorageController;
import github.kasuminova.novaeng.client.gui.widget.estorage.EStorageGraphBar;
import github.kasuminova.novaeng.client.gui.widget.estorage.Graph;
import github.kasuminova.novaeng.client.gui.widget.estorage.event.ESGUIDataUpdateEvent;
import github.kasuminova.novaeng.common.block.ecotech.estorage.prop.DriveStorageType;
import github.kasuminova.novaeng.common.container.data.EStorageCellData;
import github.kasuminova.novaeng.common.container.data.EStorageEnergyData;
import github.kasuminova.novaeng.common.crafttweaker.util.NovaEngUtils;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageCellDrive;
import java.util.Collections;
import net.minecraft.client.resources.I18n;
import org.lwjgl.input.Keyboard;

public class EStorageGraph
extends Row {
    protected final GuiEStorageController controllerGUI;
    protected final EStorageGraphBar graphBar;

    public EStorageGraph(GuiEStorageController controllerGUI) {
        this.controllerGUI = controllerGUI;
        this.graphBar = new EStorageGraphBar(controllerGUI);
        this.addWidget(this.graphBar);
        WidgetController widgetController = controllerGUI.getWidgetController();
        widgetController.addWidgetContainer((WidgetContainer)new FluidGraph(this));
        widgetController.addWidgetContainer((WidgetContainer)new ItemGraph(this));
        widgetController.addWidgetContainer((WidgetContainer)new TotalGraph(this));
        widgetController.addWidgetContainer((WidgetContainer)new FluidTypeGraph(this));
        widgetController.addWidgetContainer((WidgetContainer)new ItemTypeGraph(this));
        widgetController.addWidgetContainer((WidgetContainer)new EnergyCapacityGraph(this));
        widgetController.addWidgetContainer((WidgetContainer)new EnergyUsageGraph(this));
    }

    public void initWidget(WidgetGui gui) {
        super.initWidget(gui);
    }

    public GuiEStorageController getControllerGUI() {
        return this.controllerGUI;
    }

    public EStorageGraphBar getGraphBar() {
        return this.graphBar;
    }

    public class FluidGraph
    extends Graph {
        public FluidGraph(EStorageGraph graphParent) {
            super(graphParent, 10, 32, 60, 16, 2, 6, 225, 60, 6, true, false);
        }

        public void update(WidgetGui gui) {
            super.update(gui);
            if (!this.value.isAnimFinished()) {
                this.label.setContents(Collections.singletonList(I18n.func_135052_a((String)"gui.estorage_controller.graph.fluid.percent", (Object[])new Object[]{NovaEngUtils.formatDouble(this.value.get() * 100.0, 1)})));
            }
        }

        @Override
        public boolean onGuiEvent(GuiEvent event) {
            if (event instanceof ESGUIDataUpdateEvent) {
                double totalUsedBytes = 0.0;
                double totalMaxBytes = 0.0;
                for (EStorageCellData data : EStorageGraph.this.controllerGUI.getCellDataList()) {
                    long maxBytes = EStorageCellDrive.getMaxBytes(data);
                    totalMaxBytes += (double)maxBytes;
                    if (data.type() != DriveStorageType.FLUID) continue;
                    long usedBytes = data.usedBytes();
                    totalUsedBytes += (double)usedBytes;
                }
                this.value.set(totalMaxBytes <= 0.0 ? 0.0 : totalUsedBytes / totalMaxBytes);
            }
            return super.onGuiEvent(event);
        }
    }

    public class ItemGraph
    extends Graph {
        public ItemGraph(EStorageGraph graphParent) {
            super(graphParent, 9, 51, 65, 16, 2, 1, 232, 65, 6, true, false);
        }

        public void update(WidgetGui gui) {
            super.update(gui);
            if (!this.value.isAnimFinished()) {
                this.label.setContents(Collections.singletonList(I18n.func_135052_a((String)"gui.estorage_controller.graph.item.percent", (Object[])new Object[]{NovaEngUtils.formatDouble(this.value.get() * 100.0, 1)})));
            }
        }

        @Override
        public boolean onGuiEvent(GuiEvent event) {
            if (event instanceof ESGUIDataUpdateEvent) {
                double totalUsedBytes = 0.0;
                double totalMaxBytes = 0.0;
                for (EStorageCellData data : EStorageGraph.this.controllerGUI.getCellDataList()) {
                    long maxBytes = EStorageCellDrive.getMaxBytes(data);
                    totalMaxBytes += (double)maxBytes;
                    if (data.type() != DriveStorageType.ITEM) continue;
                    long usedBytes = data.usedBytes();
                    totalUsedBytes += (double)usedBytes;
                }
                this.value.set(totalMaxBytes <= 0.0 ? 0.0 : totalUsedBytes / totalMaxBytes);
            }
            return super.onGuiEvent(event);
        }
    }

    public class TotalGraph
    extends Graph {
        public TotalGraph(EStorageGraph graphParent) {
            super(graphParent, 8, 70, 64, 16, 2, 2, 239, 64, 6, true, false);
            this.focused = true;
            graphParent.getGraphBar().setPercentage(this.value, false);
        }

        public void update(WidgetGui gui) {
            super.update(gui);
            if (!this.value.isAnimFinished()) {
                this.label.setContents(Collections.singletonList(I18n.func_135052_a((String)"gui.estorage_controller.graph.total.percent", (Object[])new Object[]{NovaEngUtils.formatDouble(this.value.get() * 100.0, 1)})));
            }
        }

        @Override
        public boolean onGuiEvent(GuiEvent event) {
            if (event instanceof ESGUIDataUpdateEvent) {
                double totalUsedBytes = 0.0;
                double totalMaxBytes = 0.0;
                for (EStorageCellData data : EStorageGraph.this.controllerGUI.getCellDataList()) {
                    long maxBytes = EStorageCellDrive.getMaxBytes(data);
                    long usedBytes = data.usedBytes();
                    totalMaxBytes += (double)maxBytes;
                    totalUsedBytes += (double)usedBytes;
                }
                this.value.set(totalMaxBytes <= 0.0 ? 0.0 : totalUsedBytes / totalMaxBytes);
            }
            return super.onGuiEvent(event);
        }
    }

    public class FluidTypeGraph
    extends Graph {
        protected final AnimationValue totalUsedFluidTypes;
        protected final AnimationValue totalMaxFluidTypes;

        public FluidTypeGraph(EStorageGraph graphParent) {
            super(graphParent, 85, 46, 60, 16, 1, 1, 197, 60, 6, false, false);
            this.totalUsedFluidTypes = AnimationValue.ofFinished((double)0.0, (int)500, (double)0.25, (double)0.1, (double)0.25, (double)1.0);
            this.totalMaxFluidTypes = AnimationValue.ofFinished((double)0.0, (int)500, (double)0.25, (double)0.1, (double)0.25, (double)1.0);
        }

        public void update(WidgetGui gui) {
            super.update(gui);
            if (!this.value.isAnimFinished()) {
                this.label.setContents(Collections.singletonList(I18n.func_135052_a((String)"gui.estorage_controller.graph.fluid_type", (Object[])new Object[]{NovaEngUtils.formatNumber((long)this.totalUsedFluidTypes.get(), 1), NovaEngUtils.formatNumber((long)this.totalMaxFluidTypes.get(), 1)})));
            }
        }

        @Override
        public boolean onGuiEvent(GuiEvent event) {
            if (event instanceof ESGUIDataUpdateEvent) {
                int totalUsedFluidTypes = 0;
                int totalMaxFluidTypes = 0;
                for (EStorageCellData data : EStorageGraph.this.controllerGUI.getCellDataList()) {
                    if (data.type() != DriveStorageType.FLUID) continue;
                    totalUsedFluidTypes += data.usedTypes();
                    totalMaxFluidTypes += 25;
                }
                this.totalUsedFluidTypes.set((double)totalUsedFluidTypes);
                this.totalMaxFluidTypes.set((double)totalMaxFluidTypes);
                this.value.set(totalUsedFluidTypes <= 0 ? 0.0 : (double)totalUsedFluidTypes / (double)totalMaxFluidTypes);
            }
            return super.onGuiEvent(event);
        }
    }

    public class ItemTypeGraph
    extends Graph {
        protected final AnimationValue totalUsedItemTypes;
        protected final AnimationValue totalMaxItemTypes;

        public ItemTypeGraph(EStorageGraph graphParent) {
            super(graphParent, 82, 29, 59, 16, 1, 1, 197, 59, 6, false, false);
            this.totalUsedItemTypes = AnimationValue.ofFinished((double)0.0, (int)500, (double)0.25, (double)0.1, (double)0.25, (double)1.0);
            this.totalMaxItemTypes = AnimationValue.ofFinished((double)0.0, (int)500, (double)0.25, (double)0.1, (double)0.25, (double)1.0);
        }

        public void update(WidgetGui gui) {
            super.update(gui);
            if (!this.value.isAnimFinished()) {
                this.label.setContents(Collections.singletonList(I18n.func_135052_a((String)"gui.estorage_controller.graph.item_type", (Object[])new Object[]{NovaEngUtils.formatNumber((long)this.totalUsedItemTypes.get(), 1), NovaEngUtils.formatNumber((long)this.totalMaxItemTypes.get(), 1)})));
            }
        }

        @Override
        public boolean onGuiEvent(GuiEvent event) {
            if (event instanceof ESGUIDataUpdateEvent) {
                int totalUsedItemTypes = 0;
                int totalMaxItemTypes = 0;
                for (EStorageCellData data : EStorageGraph.this.controllerGUI.getCellDataList()) {
                    if (data.type() != DriveStorageType.ITEM) continue;
                    totalUsedItemTypes += data.usedTypes();
                    totalMaxItemTypes += 315;
                }
                this.totalUsedItemTypes.set((double)totalUsedItemTypes);
                this.totalMaxItemTypes.set((double)totalMaxItemTypes);
                this.value.set(totalUsedItemTypes <= 0 ? 0.0 : (double)totalUsedItemTypes / (double)totalMaxItemTypes);
            }
            return super.onGuiEvent(event);
        }
    }

    public class EnergyCapacityGraph
    extends Graph {
        protected final AnimationValue energyStored;
        protected final AnimationValue maxEnergyStore;
        protected boolean shiftDown;

        public EnergyCapacityGraph(EStorageGraph graphParent) {
            super(graphParent, 83, 78, 60, 16, 1, 1, 218, 60, 6, false, true);
            this.energyStored = AnimationValue.ofFinished((double)0.0, (int)500, (double)0.25, (double)0.1, (double)0.25, (double)1.0);
            this.maxEnergyStore = AnimationValue.ofFinished((double)0.0, (int)500, (double)0.25, (double)0.1, (double)0.25, (double)1.0);
            this.shiftDown = false;
        }

        public void update(WidgetGui gui) {
            super.update(gui);
            if (!(!this.value.isAnimFinished() || this.shiftDown && !Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54) || !this.shiftDown && Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54))) {
                return;
            }
            boolean bl = this.shiftDown = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            if (this.shiftDown) {
                this.label.setContents(Collections.singletonList(I18n.func_135052_a((String)"gui.estorage_controller.graph.energy_stored", (Object[])new Object[]{NovaEngUtils.formatNumber((long)this.energyStored.get()), NovaEngUtils.formatNumber((long)this.maxEnergyStore.get())})));
            } else {
                this.label.setContents(Collections.singletonList(I18n.func_135052_a((String)"gui.estorage_controller.graph.energy_stored.percent", (Object[])new Object[]{NovaEngUtils.formatDouble(this.value.get() * 100.0, 1)})));
            }
        }

        @Override
        public boolean onGuiEvent(GuiEvent event) {
            EStorageEnergyData energyData;
            if (event instanceof ESGUIDataUpdateEvent && (energyData = EStorageGraph.this.controllerGUI.getEnergyData()) != null && energyData.maxEnergyStore() > 0.0) {
                this.value.set(energyData.energyStored() / energyData.maxEnergyStore());
                this.energyStored.set(energyData.energyStored());
                this.maxEnergyStore.set(energyData.maxEnergyStore());
            }
            return super.onGuiEvent(event);
        }
    }

    public class EnergyUsageGraph
    extends Graph {
        protected final AnimationValue energyConsumePerTick;

        public EnergyUsageGraph(EStorageGraph graphParent) {
            super(graphParent, 83, 63, 61, 16, 1, 1, 211, 61, 6, false, false);
            this.energyConsumePerTick = AnimationValue.ofFinished((double)0.0, (int)500, (double)0.25, (double)0.1, (double)0.25, (double)1.0);
        }

        public void update(WidgetGui gui) {
            super.update(gui);
            if (!this.value.isAnimFinished()) {
                this.label.setContents(Collections.singletonList(I18n.func_135052_a((String)"gui.estorage_controller.graph.energy_usage", (Object[])new Object[]{NovaEngUtils.formatNumber((long)this.energyConsumePerTick.get())})));
            }
        }

        @Override
        public boolean onGuiEvent(GuiEvent event) {
            EStorageEnergyData energyData;
            if (event instanceof ESGUIDataUpdateEvent && (energyData = EStorageGraph.this.controllerGUI.getEnergyData()) != null) {
                if (energyData.energyStored() > 0.0) {
                    this.value.set(energyData.energyConsumePerTick() / energyData.energyStored());
                } else {
                    this.value.set(0.0);
                }
                this.energyConsumePerTick.set(energyData.energyConsumePerTick());
            }
            return super.onGuiEvent(event);
        }
    }
}

