/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.client.gui.widget.estorage;

import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.util.TextureProperties;
import github.kasuminova.mmce.client.gui.widget.MultiLineLabel;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.container.Column;
import github.kasuminova.novaeng.common.block.ecotech.estorage.prop.DriveStorageLevel;
import github.kasuminova.novaeng.common.block.ecotech.estorage.prop.DriveStorageType;
import github.kasuminova.novaeng.common.container.data.EStorageCellData;
import github.kasuminova.novaeng.common.crafttweaker.util.NovaEngUtils;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageCellDrive;
import java.util.Collections;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class EStorageCellInfo
extends Column {
    public static final ResourceLocation BG_TEX_RES = new ResourceLocation("novaeng_core", "textures/gui/estorage_controller_elements.png");
    public static final int CELL_BACKGROUND_TEXTURE_WIDTH = 67;
    public static final int CELL_BACKGROUND_TEXTURE_HEIGHT = 26;
    public static final int CELL_TYPE_BACKGROUND_WIDTH = 8;
    public static final int CELL_TYPE_BACKGROUND_HEIGHT = 26;
    public static final TextureProperties CELL_BACKGROUND_L4 = new TextureProperties(BG_TEX_RES, 1, 1, 67, 26);
    public static final TextureProperties CELL_BACKGROUND_L6 = new TextureProperties(BG_TEX_RES, 1, 28, 67, 26);
    public static final TextureProperties CELL_BACKGROUND_L9 = new TextureProperties(BG_TEX_RES, 1, 55, 67, 26);
    public static final TextureProperties CELL_TYPE_BACKGROUND_ITEM = new TextureProperties(BG_TEX_RES, 19, 82, 8, 26);
    public static final TextureProperties CELL_TYPE_BACKGROUND_FLUID = new TextureProperties(BG_TEX_RES, 10, 82, 8, 26);
    protected TextureProperties cellBackground = TextureProperties.EMPTY;
    protected TextureProperties cellTypeBackground = TextureProperties.EMPTY;
    protected final EStorageCellData data;

    public EStorageCellInfo(EStorageCellData data) {
        this.data = data;
        this.width = 67;
        this.height = 26;
        this.initBackground();
        this.initInfo();
        this.setMarginDown(2);
        this.setUseScissor(false);
    }

    protected void preRenderInternal(WidgetGui widgetGui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        this.cellBackground.renderIfPresent(renderPos, widgetGui);
        this.cellTypeBackground.renderIfPresent(renderPos, widgetGui);
        super.preRenderInternal(widgetGui, renderSize, renderPos, mousePos);
    }

    protected void initBackground() {
        switch (this.data.level()) {
            case A: {
                this.cellBackground = CELL_BACKGROUND_L4;
                break;
            }
            case B: {
                this.cellBackground = CELL_BACKGROUND_L6;
                break;
            }
            case C: {
                this.cellBackground = CELL_BACKGROUND_L9;
            }
        }
        switch (this.data.type()) {
            case ITEM: {
                this.cellTypeBackground = CELL_TYPE_BACKGROUND_ITEM;
                break;
            }
            case FLUID: {
                this.cellTypeBackground = CELL_TYPE_BACKGROUND_FLUID;
            }
        }
    }

    protected void initInfo() {
        String string;
        String string2;
        DriveStorageType type = this.data.type();
        DriveStorageLevel level = this.data.level();
        int usedTypes = this.data.usedTypes();
        long usedBytes = this.data.usedBytes();
        int maxTypes = EStorageCellDrive.getMaxTypes(this.data);
        long maxBytes = EStorageCellDrive.getMaxBytes(this.data);
        StringBuilder stringBuilder = new StringBuilder().append("gui.estorage_controller.cell_info.");
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case EMPTY: {
                string2 = "unknown";
                break;
            }
            case ITEM: {
                string2 = "item";
                break;
            }
            case FLUID: {
                string2 = "fluid";
            }
        }
        String typeName = I18n.func_135052_a((String)stringBuilder.append(string2).toString(), (Object[])new Object[0]);
        switch (level) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case EMPTY: {
                string = "unknown";
                break;
            }
            case A: {
                string = "L4";
                break;
            }
            case B: {
                string = "L6";
                break;
            }
            case C: {
                string = "L9";
            }
        }
        String levelName = string;
        this.getWidgets().clear();
        this.addWidget(new MultiLineLabel(Collections.singletonList(I18n.func_135052_a((String)"gui.estorage_controller.cell_info.tip.0", (Object[])new Object[]{typeName, levelName}))).setAutoWrap(false).setScale(0.6f).setHeight(7).setMargin(10, 0, 2, 0));
        this.addWidget(new MultiLineLabel(Collections.singletonList(I18n.func_135052_a((String)"gui.estorage_controller.cell_info.tip.1", (Object[])new Object[]{usedTypes, maxTypes}))).setAutoWrap(false).setScale(0.6f).setHeight(7).setMargin(10, 0, 0, 0));
        this.addWidget(new MultiLineLabel(Collections.singletonList(I18n.func_135052_a((String)"gui.estorage_controller.cell_info.tip.2", (Object[])new Object[]{NovaEngUtils.formatNumber(usedBytes, 1), NovaEngUtils.formatNumber(maxBytes, 1)}))).setAutoWrap(false).setScale(0.6f).setHeight(7).setMargin(10, 0, 0, 0));
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

