/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.client.gui.widget.estorage;

import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.widget.base.DynamicWidget;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.container.ScrollingColumn;
import github.kasuminova.mmce.client.gui.widget.event.GuiEvent;
import github.kasuminova.novaeng.client.gui.GuiEStorageController;
import github.kasuminova.novaeng.client.gui.widget.estorage.EStorageCellInfo;
import github.kasuminova.novaeng.client.gui.widget.estorage.event.ESGUIDataUpdateEvent;
import github.kasuminova.novaeng.common.container.data.EStorageCellData;
import java.util.Iterator;

public class CellInfoColumn
extends ScrollingColumn {
    protected final GuiEStorageController controllerGUI;

    public CellInfoColumn(GuiEStorageController controllerGUI) {
        this.controllerGUI = controllerGUI;
        this.setWidthHeight(68, 172);
        this.scrollbar.setDisabled(true);
        this.scrollbar.setMouseWheelCheckPos(false);
    }

    public void update(WidgetGui gui) {
        super.update(gui);
        int size = this.getWidgets().size();
        if (size > 0) {
            this.scrollbar.setScrollUnit(this.scrollbar.getRange() / size);
        }
    }

    public boolean onGuiEvent(GuiEvent event) {
        if (event instanceof ESGUIDataUpdateEvent) {
            this.getWidgets().clear();
            Iterator<EStorageCellData> it = this.controllerGUI.getCellDataList().iterator();
            while (it.hasNext()) {
                EStorageCellData data = it.next();
                EStorageCellInfo info = new EStorageCellInfo(data);
                if (!it.hasNext()) {
                    info.setMarginDown(0);
                }
                this.addWidget((DynamicWidget)info);
            }
        }
        return super.onGuiEvent(event);
    }

    public boolean onMouseDWheel(MousePos mousePos, RenderPos renderPos, int wheel) {
        int width = this.width;
        int height = this.height;
        int y = this.getTotalHeight() > height ? -this.scrollbar.getCurrentScroll() : 0;
        for (DynamicWidget widget : this.widgets) {
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, width, y)) == null) continue;
            RenderPos absRenderPos = widgetRenderPos.add(renderPos);
            if (widget.onMouseDWheel(mousePos.relativeTo(widgetRenderPos), absRenderPos, wheel)) {
                return true;
            }
            y += widget.getMarginUp() + widget.getHeight() + widget.getMarginDown();
        }
        if (this.isMouseOver(mousePos)) {
            return this.scrollbar.onMouseDWheel(null, null, wheel);
        }
        return false;
    }
}

