/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.client.gui.widget.efabricator;

import github.kasuminova.mmce.client.gui.widget.MultiLineLabel;
import github.kasuminova.mmce.client.gui.widget.base.DynamicWidget;
import github.kasuminova.mmce.client.gui.widget.container.Row;
import github.kasuminova.mmce.client.gui.widget.event.GuiEvent;
import github.kasuminova.novaeng.client.gui.widget.efabricator.event.EFGUIDataUpdateEvent;
import github.kasuminova.novaeng.common.crafttweaker.util.NovaEngUtils;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import net.minecraft.client.resources.I18n;

public class TotalCraftedLabel
extends Row {
    private final MultiLineLabel label;
    private final Deque<Double> history = new ArrayDeque<Double>();
    private long value = 0L;

    public TotalCraftedLabel() {
        this.label = new MultiLineLabel(Collections.singletonList(I18n.func_135052_a((String)"gui.efabricator.total_crafted", (Object[])new Object[]{0})));
        this.label.setScale(0.8f);
        this.label.setAutoWrap(false);
        this.addWidget((DynamicWidget)this.label);
    }

    public boolean onGuiEvent(GuiEvent event) {
        if (event instanceof EFGUIDataUpdateEvent) {
            EFGUIDataUpdateEvent efGUIEvent = (EFGUIDataUpdateEvent)event;
            this.onValueUpdate(efGUIEvent.getEFGui().getData().totalCrafted());
        }
        return super.onGuiEvent(event);
    }

    public void onValueUpdate(long newValue) {
        if (this.history.size() >= 10) {
            this.history.pollLast();
        }
        int added = (int)(newValue - this.value);
        if (this.value != 0L && added > 0) {
            double craftPerTick = (float)added * 2.0f / 20.0f;
            this.history.push(craftPerTick);
            double avgCraftPerTick = this.history.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
            this.updateLabel(newValue, avgCraftPerTick);
        } else {
            this.history.push(0.0);
            double avgCraftPerTick = this.history.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
            if (avgCraftPerTick > 0.0) {
                this.updateLabel(newValue, avgCraftPerTick);
            } else {
                this.label.setContents(Collections.singletonList(I18n.func_135052_a((String)"gui.efabricator.total_crafted", (Object[])new Object[]{NovaEngUtils.formatDecimal(newValue)})));
            }
        }
        this.value = newValue;
    }

    private void updateLabel(long newValue, double avgCraftPerTick) {
        this.label.setContents(Collections.singletonList(I18n.func_135052_a((String)"gui.efabricator.total_crafted.update", (Object[])new Object[]{NovaEngUtils.formatDecimal(newValue), avgCraftPerTick <= 0.1 ? "<0.1" : NovaEngUtils.formatDouble(avgCraftPerTick, 1)})));
    }
}

