/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.client.gui.widget.efabricator;

import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.util.TextureProperties;
import github.kasuminova.mmce.client.gui.widget.MultiLineLabel;
import github.kasuminova.mmce.client.gui.widget.base.DynamicWidget;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.container.Column;
import github.kasuminova.mmce.client.gui.widget.container.Row;
import github.kasuminova.mmce.client.gui.widget.event.GuiEvent;
import github.kasuminova.novaeng.client.gui.GuiEFabricatorController;
import github.kasuminova.novaeng.client.gui.widget.ProgressBar;
import github.kasuminova.novaeng.client.gui.widget.efabricator.event.EFGUIDataUpdateEvent;
import github.kasuminova.novaeng.common.container.data.EFabricatorData;
import java.util.Collections;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class StatisticPanel
extends Row {
    public static final int WIDTH = 148;
    public static final int HEIGHT = 36;
    public static final TextureProperties TEXTURE_BACKGROUND = new TextureProperties(GuiEFabricatorController.TEXTURES_ELEMENTS, 1, 219, 148, 36);

    public StatisticPanel() {
        this.width = 148;
        this.height = 36;
        Modules modules = new Modules();
        QueueStatistics queueStatistics = new QueueStatistics();
        ParallelismStatistics parallelismStatistics = new ParallelismStatistics();
        this.addWidgets(new DynamicWidget[]{modules.setMarginLeft(2).setMarginUp(2), queueStatistics.setMarginLeft(1).setMarginUp(2), parallelismStatistics.setMarginLeft(1).setMarginUp(2)});
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    protected void preRenderInternal(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        TEXTURE_BACKGROUND.render(renderPos, gui);
        super.preRenderInternal(gui, renderSize, renderPos, mousePos);
    }

    public static class Modules
    extends Column {
        public static final int WIDTH = 40;
        public static final int HEIGHT = 32;
        public static final TextureProperties TEXTURE_BACKGROUND = new TextureProperties(GuiEFabricatorController.TEXTURES_ELEMENTS, 1, 186, 40, 32);
        private final Level level = new Level();
        private final MultiLineLabel patternBusCount;
        private final MultiLineLabel parallelProcCount;
        private final MultiLineLabel workerCount;

        public Modules() {
            this.width = 40;
            this.height = 32;
            this.patternBusCount = new MultiLineLabel(Collections.singletonList(I18n.func_135052_a((String)"gui.efabricator.pattern_bus.count", (Object[])new Object[]{0})));
            this.parallelProcCount = new MultiLineLabel(Collections.singletonList(I18n.func_135052_a((String)"gui.efabricator.parallel_proc.count", (Object[])new Object[]{0})));
            this.workerCount = new MultiLineLabel(Collections.singletonList(I18n.func_135052_a((String)"gui.efabricator.worker.count", (Object[])new Object[]{0})));
            this.addWidgets(new DynamicWidget[]{this.level.setMargin(2, 0, 2, 2), this.patternBusCount.setAutoRecalculateSize(false).setAutoWrap(false).setWidth(this.width - 2).setScale(0.6f).setMargin(1), this.parallelProcCount.setAutoRecalculateSize(false).setAutoWrap(false).setWidth(this.width - 2).setScale(0.6f).setMargin(1), this.workerCount.setAutoRecalculateSize(false).setAutoWrap(false).setWidth(this.width - 2).setScale(0.6f).setMargin(1)});
        }

        public boolean onGuiEvent(GuiEvent event) {
            if (event instanceof EFGUIDataUpdateEvent) {
                EFGUIDataUpdateEvent efGUIEvent = (EFGUIDataUpdateEvent)event;
                EFabricatorData data = efGUIEvent.getEFGui().getData();
                if (data == null) {
                    return super.onGuiEvent(event);
                }
                this.patternBusCount.setContents(Collections.singletonList(I18n.func_135052_a((String)"gui.efabricator.pattern_bus.count", (Object[])new Object[]{data.length() * 2})));
                this.parallelProcCount.setContents(Collections.singletonList(I18n.func_135052_a((String)"gui.efabricator.parallel_proc.count", (Object[])new Object[]{data.length() * 2})));
                this.workerCount.setContents(Collections.singletonList(I18n.func_135052_a((String)"gui.efabricator.worker.count", (Object[])new Object[]{data.length()})));
            }
            return super.onGuiEvent(event);
        }

        public Level getLevel() {
            return this.level;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        protected void preRenderInternal(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
            TEXTURE_BACKGROUND.render(renderPos, gui);
            super.preRenderInternal(gui, renderSize, renderPos, mousePos);
        }

        public static class Level
        extends DynamicWidget {
            public static final TextureProperties LEVEL = new TextureProperties(GuiEFabricatorController.TEXTURES_ELEMENTS, 186, 1, 4, 9);
            public static final TextureProperties L0 = new TextureProperties(GuiEFabricatorController.TEXTURES_ELEMENTS, 191, 1, 5, 9);
            public static final TextureProperties L4 = new TextureProperties(GuiEFabricatorController.TEXTURES_ELEMENTS, 197, 1, 5, 9);
            public static final TextureProperties L6 = new TextureProperties(GuiEFabricatorController.TEXTURES_ELEMENTS, 203, 1, 5, 9);
            public static final TextureProperties L9 = new TextureProperties(GuiEFabricatorController.TEXTURES_ELEMENTS, 209, 1, 5, 9);
            private TextureProperties texture = L0;

            public Level() {
                this.setWidthHeight(LEVEL.width() + L0.width() + 1, LEVEL.height());
            }

            public boolean onGuiEvent(GuiEvent event) {
                if (event instanceof EFGUIDataUpdateEvent) {
                    EFGUIDataUpdateEvent efGUIEvent = (EFGUIDataUpdateEvent)event;
                    EFabricatorData data = efGUIEvent.getEFGui().getData();
                    if (data == null) {
                        return super.onGuiEvent(event);
                    }
                    switch (data.level()) {
                        case L4: {
                            this.texture = L4;
                            break;
                        }
                        case L6: {
                            this.texture = L6;
                            break;
                        }
                        case L9: {
                            this.texture = L9;
                            break;
                        }
                        default: {
                            this.texture = L0;
                        }
                    }
                }
                return super.onGuiEvent(event);
            }

            public void render(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
                LEVEL.render(renderPos, gui);
                this.texture.renderIfPresent(renderPos.add(new RenderPos(LEVEL.width() + 1, 0)), gui);
            }

            public TextureProperties getTexture() {
                return this.texture;
            }

            public Level setTexture(TextureProperties texture) {
                this.texture = texture;
                return this;
            }
        }
    }

    public static class QueueStatistics
    extends Row {
        public static final int WIDTH = 51;
        public static final int HEIGHT = 32;
        public static final TextureProperties TEXTURE_BACKGROUND = new TextureProperties(GuiEFabricatorController.TEXTURES_ELEMENTS, 42, 186, 51, 32);
        private final Info info;
        private final ProgressBar queueStatisticsBar;

        public QueueStatistics() {
            this.width = 51;
            this.height = 32;
            this.queueStatisticsBar = new ProgressBar();
            this.info = new Info();
            this.addWidgets(new DynamicWidget[]{this.info.setMargin(2, 0, 2, 0), this.queueStatisticsBar.setBackgroundTexture(TextureProperties.of((ResourceLocation)TEXTURE_BACKGROUND.texRes(), (int)146, (int)190, (int)9, (int)28)).addForegroundTexture(TextureProperties.of((ResourceLocation)TEXTURE_BACKGROUND.texRes(), (int)150, (int)227, (int)9, (int)28)).setDownToUp(true).setMaxProgress(1.0f).setWidthHeight(9, 28).setMargin(0, 0, 2, 0)});
        }

        public boolean onGuiEvent(GuiEvent event) {
            if (event instanceof EFGUIDataUpdateEvent) {
                EFGUIDataUpdateEvent efGUIEvent = (EFGUIDataUpdateEvent)event;
                EFabricatorData data = efGUIEvent.getEFGui().getData();
                if (data == null) {
                    return super.onGuiEvent(event);
                }
                int length = data.length();
                int queueDepth = 32;
                if (data.overclocked()) {
                    queueDepth = data.level().applyOverclockQueueDepth(queueDepth);
                }
                int works = data.workers().stream().mapToInt(EFabricatorData.WorkerStatus::queueLength).sum();
                this.queueStatisticsBar.setMaxProgress(length * queueDepth).setProgress(works);
                this.info.setProgress(works, length * queueDepth);
            }
            return super.onGuiEvent(event);
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        protected void preRenderInternal(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
            TEXTURE_BACKGROUND.render(renderPos, gui);
            super.preRenderInternal(gui, renderSize, renderPos, mousePos);
        }

        public static class Info
        extends Column {
            public static final int WIDTH = 51;
            public static final int HEIGHT = 32;
            private final MultiLineLabel progressPercent;
            private final MultiLineLabel progress;

            public Info() {
                this.width = 38;
                this.height = 32;
                this.progressPercent = new MultiLineLabel(Collections.singletonList(I18n.func_135052_a((String)"gui.efabricator.crafting_progress.0", (Object[])new Object[]{0})));
                this.progress = new MultiLineLabel(Collections.singletonList(I18n.func_135052_a((String)"gui.efabricator.crafting_progress.1", (Object[])new Object[]{0, 0})));
                this.addWidgets(new DynamicWidget[]{this.progressPercent.setAutoRecalculateSize(false).setAutoWrap(false).setWidth(this.width - 2).setScale(0.6f).setMargin(1), this.progress.setAutoRecalculateSize(false).setAutoWrap(false).setWidth(this.width - 2).setScale(0.6f).setMargin(1)});
            }

            public Info setProgress(int prog, int max) {
                this.progressPercent.setContents(Collections.singletonList(I18n.func_135052_a((String)"gui.efabricator.crafting_progress.0", (Object[])new Object[]{max <= 0 ? 0 : prog * 100 / max})));
                this.progress.setContents(Collections.singletonList(I18n.func_135052_a((String)"gui.efabricator.crafting_progress.1", (Object[])new Object[]{prog, max})));
                return this;
            }

            public int getWidth() {
                return this.width;
            }

            public int getHeight() {
                return this.height;
            }
        }
    }

    public static class ParallelismStatistics
    extends Row {
        public static final int WIDTH = 51;
        public static final int HEIGHT = 32;
        public static final TextureProperties TEXTURE_BACKGROUND = new TextureProperties(GuiEFabricatorController.TEXTURES_ELEMENTS, 94, 186, 51, 32);
        private final Info info;
        private final ProgressBar parallelismBar;

        public ParallelismStatistics() {
            this.width = 51;
            this.height = 32;
            this.info = new Info();
            this.parallelismBar = new ProgressBar();
            this.addWidgets(new DynamicWidget[]{this.info.setMargin(2, 0, 2, 0), this.parallelismBar.setBackgroundTexture(TextureProperties.of((ResourceLocation)TEXTURE_BACKGROUND.texRes(), (int)156, (int)190, (int)9, (int)28)).addForegroundTexture(TextureProperties.of((ResourceLocation)TEXTURE_BACKGROUND.texRes(), (int)160, (int)227, (int)9, (int)28)).setDownToUp(true).setMaxProgress(1.0f).setWidthHeight(9, 28).setMargin(0, 0, 2, 0)});
        }

        public boolean onGuiEvent(GuiEvent event) {
            if (event instanceof EFGUIDataUpdateEvent) {
                EFGUIDataUpdateEvent efGUIEvent = (EFGUIDataUpdateEvent)event;
                EFabricatorData data = efGUIEvent.getEFGui().getData();
                if (data == null) {
                    return super.onGuiEvent(event);
                }
                int length = data.length();
                int queueDepth = 32;
                if (data.overclocked()) {
                    queueDepth = data.level().applyOverclockQueueDepth(queueDepth);
                }
                int parallelism = data.maxParallelism();
                this.parallelismBar.setMaxProgress(parallelism).setProgress(Math.min(parallelism, length * queueDepth));
                this.info.setParallelism(parallelism, length * queueDepth);
            }
            return super.onGuiEvent(event);
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        protected void preRenderInternal(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
            TEXTURE_BACKGROUND.render(renderPos, gui);
            super.preRenderInternal(gui, renderSize, renderPos, mousePos);
        }

        public static class Info
        extends Column {
            public static final int WIDTH = 51;
            public static final int HEIGHT = 32;
            private final MultiLineLabel parallelism;
            private final MultiLineLabel parallelismLimit;
            private final MultiLineLabel parallelismOverflow;

            public Info() {
                this.width = 38;
                this.height = 32;
                this.parallelism = new MultiLineLabel(Collections.singletonList(I18n.func_135052_a((String)"gui.efabricator.total_parallelism", (Object[])new Object[]{0})));
                this.parallelismLimit = new MultiLineLabel(Collections.singletonList(I18n.func_135052_a((String)"gui.efabricator.total_parallelism.limit", (Object[])new Object[]{0})));
                this.parallelismOverflow = new MultiLineLabel(Collections.singletonList(I18n.func_135052_a((String)"gui.efabricator.total_parallelism.overflow", (Object[])new Object[]{0, 0})));
                this.addWidgets(new DynamicWidget[]{this.parallelism.setAutoRecalculateSize(false).setAutoWrap(false).setWidth(this.width - 2).setScale(0.6f).setMargin(1), this.parallelismLimit.setAutoRecalculateSize(false).setAutoWrap(false).setWidth(this.width - 2).setScale(0.6f).setMargin(1), this.parallelismOverflow.setAutoRecalculateSize(false).setAutoWrap(false).setWidth(this.width - 2).setScale(0.6f).setMargin(1)});
            }

            public Info setParallelism(int parallelism, int parallelismLimit) {
                this.parallelism.setContents(Collections.singletonList(I18n.func_135052_a((String)"gui.efabricator.total_parallelism", (Object[])new Object[]{parallelism})));
                this.parallelismLimit.setContents(Collections.singletonList(I18n.func_135052_a((String)"gui.efabricator.total_parallelism.limit", (Object[])new Object[]{parallelismLimit})));
                int overflow = Math.max(parallelism - parallelismLimit, 0);
                this.parallelismOverflow.setContents(Collections.singletonList(I18n.func_135052_a((String)"gui.efabricator.total_parallelism.overflow", (Object[])new Object[]{overflow, overflow == 0 ? 0 : overflow * 100 / parallelism})));
                return this;
            }

            public int getWidth() {
                return this.width;
            }

            public int getHeight() {
                return this.height;
            }
        }
    }
}

